/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite.gridcoverage2d;

import it.geosolutions.jaiext.range.Range;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.util.HashMap;
import java.util.Map;
import javax.media.jai.ROI;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.TypeMap;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.factory.Hints;
import org.geotools.image.ImageWorker;
import org.geotools.renderer.i18n.Vocabulary;
import org.geotools.renderer.lite.gridcoverage2d.ChannelSelectionNode;
import org.geotools.renderer.lite.gridcoverage2d.ColorMapNode;
import org.geotools.renderer.lite.gridcoverage2d.ColorMapUtilities;
import org.geotools.renderer.lite.gridcoverage2d.ContrastEnhancementNode;
import org.geotools.renderer.lite.gridcoverage2d.RootNode;
import org.geotools.renderer.lite.gridcoverage2d.SubchainStyleVisitorCoverageProcessingAdapter;
import org.geotools.resources.coverage.CoverageUtilities;
import org.geotools.styling.ChannelSelection;
import org.geotools.styling.ColorMap;
import org.geotools.styling.ContrastEnhancement;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.StyleVisitor;
import org.geotools.util.SimpleInternationalString;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.filter.expression.Expression;

public class RasterSymbolizerHelper
extends SubchainStyleVisitorCoverageProcessingAdapter
implements StyleVisitor {
    private float opacity = 1.0f;

    @Override
    public GridCoverage2D execute() {
        GridSampleDimension[] sd;
        GridCoverage2D output = (GridCoverage2D)super.execute();
        RenderedImage outputImage = output.getRenderedImage();
        Range nodata = CoverageUtilities.getNoDataProperty(output) != null ? CoverageUtilities.getNoDataProperty(output).getAsRange() : null;
        ROI roiProp = CoverageUtilities.getROIProperty(output);
        SampleModel outputImageSampleModel = outputImage.getSampleModel();
        int numBands = outputImageSampleModel.getNumBands();
        int dataType = outputImageSampleModel.getDataType();
        if (numBands > 4) {
            int visibleBand = CoverageUtilities.getVisibleBand(outputImage);
            outputImage = new ImageWorker(outputImage).setRenderingHints(this.getHints()).retainBands(new int[]{visibleBand}).getRenderedImage();
            sd = new GridSampleDimension[]{output.getSampleDimension(visibleBand)};
        } else {
            sd = output.getSampleDimensions();
        }
        switch (dataType) {
            case 1: {
                if (outputImage.getColorModel() instanceof IndexColorModel) break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                ImageWorker w = new ImageWorker(outputImage);
                outputImage = w.setROI(roiProp).setNoData(nodata).setRenderingHints(this.getHints()).rescaleToBytes().getRenderedImage();
                roiProp = w.getROI();
                nodata = w.getNoData();
            }
        }
        HashMap<String, Object> properties = output.getProperties();
        if (properties == null) {
            properties = new HashMap<String, Object>();
        }
        CoverageUtilities.setNoDataProperty((Map<String, Object>)properties, nodata);
        CoverageUtilities.setROIProperty(properties, roiProp);
        if (this.opacity < 1.0f) {
            ImageWorker ow = new ImageWorker(outputImage);
            ow.setROI(roiProp);
            ow.setNoData(nodata);
            RenderedImage finalImage = ow.applyOpacity(this.opacity).getRenderedImage();
            numBands = finalImage.getSampleModel().getNumBands();
            sd = new GridSampleDimension[numBands];
            for (int i = 0; i < numBands; ++i) {
                sd[i] = new GridSampleDimension(TypeMap.getColorInterpretation(finalImage.getColorModel(), i).name());
            }
            CoverageUtilities.setNoDataProperty(properties, ow.getNoData());
            CoverageUtilities.setROIProperty(properties, ow.getROI());
            return this.getCoverageFactory().create((CharSequence)output.getName(), finalImage, output.getGridGeometry(), sd, new GridCoverage[]{output}, properties);
        }
        return this.getCoverageFactory().create((CharSequence)output.getName(), outputImage, output.getGridGeometry(), sd, new GridCoverage[]{output}, properties);
    }

    public RasterSymbolizerHelper(GridCoverage2D sourceCoverage, Hints hints) {
        super(1, hints, SimpleInternationalString.wrap(Vocabulary.format(8)), SimpleInternationalString.wrap("Simple Coverage Processing Node for RasterSymbolizerHelper"));
        this.addSource(new RootNode(sourceCoverage, hints));
    }

    @Override
    public void visit(RasterSymbolizer rs) {
        Number number;
        ColorMapUtilities.ensureNonNull("RasterSymbolizer", rs);
        ChannelSelectionNode csNode = new ChannelSelectionNode();
        ColorMapNode cmNode = new ColorMapNode(this.getHints());
        ContrastEnhancementNode ceNode = new ContrastEnhancementNode(this.getHints());
        this.setSink(ceNode);
        ChannelSelection cs = rs.getChannelSelection();
        csNode.addSource(this.getSource(0));
        csNode.addSink(cmNode);
        csNode.visit(cs);
        ColorMap cm = rs.getColorMap();
        cmNode.addSource(csNode);
        csNode.addSink(cmNode);
        cmNode.visit(cm);
        ContrastEnhancement ce = rs.getContrastEnhancement();
        ceNode.addSource(cmNode);
        cmNode.addSink(ceNode);
        ceNode.visit(ce);
        Expression op = rs.getOpacity();
        if (op != null && (number = (Number)op.evaluate(null, Float.class)) != null) {
            this.opacity = number.floatValue();
        }
    }
}

