/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.repo.auth.app.entities;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;

public class SAMLResourceHelpers {
    public static String readCertificate(String certificateFilename) throws IOException {
        List certLines = Files.readLines((File)new File(certificateFilename), (Charset)Charsets.UTF_8);
        UnmodifiableIterator filteredLines = Iterators.filter(certLines.iterator(), (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return !input.startsWith("-----");
            }
        });
        return Joiner.on((String)"").join((Iterator)filteredLines);
    }

    public static byte[] readPrivateKey(String privateKeyFileName) throws IOException {
        return Files.toByteArray((File)new File(privateKeyFileName));
    }
}

