/*
 * Decompiled with CFR 0.152.
 */
package it.eng.edison.messages.server.util;

import com.netflix.astyanax.AstyanaxConfiguration;
import com.netflix.astyanax.AstyanaxContext;
import com.netflix.astyanax.AstyanaxTypeFactory;
import com.netflix.astyanax.Keyspace;
import com.netflix.astyanax.connectionpool.ConnectionPoolConfiguration;
import com.netflix.astyanax.connectionpool.ConnectionPoolMonitor;
import com.netflix.astyanax.connectionpool.NodeDiscoveryType;
import com.netflix.astyanax.connectionpool.impl.ConnectionPoolConfigurationImpl;
import com.netflix.astyanax.connectionpool.impl.CountingConnectionPoolMonitor;
import com.netflix.astyanax.impl.AstyanaxConfigurationImpl;
import com.netflix.astyanax.thrift.ThriftFamilyFactory;
import java.util.List;
import java.util.Properties;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;

public class ConnectCassandra {
    private AstyanaxContext<Keyspace> context;
    private Keyspace keyspace;
    private String dbserver;
    private String dbPort;
    private String clusterName;
    private String keySpaceName;
    private static final String HOST_PROPERTY = "host";
    private static final String HOST_PORT_PROPERTY = "port";
    private static final String CLUSTER_NAME_PROPERTY = "cluster";
    private static final String KEY_SPACE_NAME_PROPERTY = "keyspace";
    private static final String RUNTIME_RESOURCE_NAME = "SocialPortalDataStore";
    private static final String PLATFORM_NAME = "Cassandra";
    private static final String DEFAULT_CONFIGURATION = "/org/gcube/portal/databook/server/resources/databook.properties";

    public ConnectCassandra() {
        Properties properties = new Properties();
        try {
            ClassLoader cl = this.getClass().getClassLoader();
            properties.load(cl.getResourceAsStream("messaging.properties"));
            this.dbserver = properties.getProperty("DB_Server");
            this.dbPort = properties.getProperty("DB_Port");
            this.clusterName = properties.getProperty("ClusterName");
            this.keySpaceName = properties.getProperty("KeySpaceName");
            System.out.println("dbserver : " + this.dbserver);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Keyspace getKeyspace() {
        this.context = new AstyanaxContext.Builder().forCluster(this.clusterName).forKeyspace(this.keySpaceName).withAstyanaxConfiguration((AstyanaxConfiguration)new AstyanaxConfigurationImpl().setCqlVersion("3.3.1").setTargetCassandraVersion("2.2.5").setDiscoveryType(NodeDiscoveryType.RING_DESCRIBE)).withConnectionPoolConfiguration((ConnectionPoolConfiguration)new ConnectionPoolConfigurationImpl("MyConnectionPool").setPort(Integer.parseInt(this.dbPort)).setMaxConnsPerHost(2).setSeeds(this.dbserver + ":" + this.dbPort).setConnectTimeout(2000)).withConnectionPoolMonitor((ConnectionPoolMonitor)new CountingConnectionPoolMonitor()).buildKeyspace((AstyanaxTypeFactory)ThriftFamilyFactory.getInstance());
        this.context.start();
        this.keyspace = (Keyspace)this.context.getClient();
        return this.keyspace;
    }

    private List<ServiceEndpoint> getConfigurationFromIS(String infrastructureName) throws Exception {
        Object context = null;
        String scope = "/";
        if (infrastructureName != null && !infrastructureName.isEmpty()) {
            scope = scope + infrastructureName;
        } else {
            scope = scope + context.getInfrastructureName();
            System.out.println("context.getInfrastructureName()" + context.getInfrastructureName());
        }
        String currScope = ScopeProvider.instance.get();
        ScopeProvider.instance.set(scope);
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Name/text() eq 'SocialPortalDataStore'");
        query.addCondition("$resource/Profile/Platform/Name/text() eq 'Cassandra'");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        List toReturn = client.submit((Query)query);
        ScopeProvider.instance.set(currScope);
        return toReturn;
    }
}

