package it.eng.edison.messages.client;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.Label;
import com.github.gwtbootstrap.client.ui.base.Style;
import com.github.gwtbootstrap.client.ui.constants.IconSize;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;

/**
 * Created by pino on 28/06/2016.
 */
public class ChatDialogBox  extends DialogBox {

    public ChatDialogBox(String textMessage, String typeMessage) {
        VerticalPanel vPanel = new VerticalPanel();
        HorizontalPanel hPanel = new HorizontalPanel();
        setText(typeMessage);

        setModal(true);
        setAnimationEnabled(true);
        center();
        setGlassEnabled(true);

        Label messageLabel = new Label();
        messageLabel.setText(textMessage);


        Button close = new Button();
        close.setTitle("Close window");
        close.setIcon(IconType.REMOVE);
        close.setIconSize(IconSize.TWO_TIMES);
        close.setStyle(new Style() {
            @Override
            public String get() {
                return "attachButton";
            }
        });
        close.addClickHandler(new ClickHandler() {
            public void onClick(ClickEvent event) {
                ChatDialogBox.this.hide();
            }
        });
        hPanel.add(close);
        vPanel.add(messageLabel);
        vPanel.add(hPanel);
        setWidget(vPanel);

    }
}
