package it.eng.edison.messages.client;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.FileUpload;
import com.github.gwtbootstrap.client.ui.base.Style;
import com.github.gwtbootstrap.client.ui.constants.IconSize;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;

/**
 * Created by Administrator on 15/06/2016.
 */
public class UploadDialogBox extends DialogBox {

    String fileName = "";


    public UploadDialogBox(final MessagesUI messagesUI) {

        VerticalPanel vPanel = new VerticalPanel();
        HorizontalPanel hPanel = new HorizontalPanel();
        setText("Upload File");
        center();
        setModal(true);
        setAnimationEnabled(true);
        setGlassEnabled(true);
        final FormPanel form = new FormPanel();

        form.setAction(GWT.getModuleBaseURL()+"edisonMessagesUpload");
        form.setEncoding(FormPanel.ENCODING_MULTIPART);
        form.setMethod(FormPanel.METHOD_POST);

        Button close = new Button();
        close.setTitle("Close window");
        close.setIcon(IconType.REMOVE);
        close.setIconSize(IconSize.TWO_TIMES);
        close.setStyle(new Style() {
            @Override
            public String get() {
                return "attachButton";
            }
        });
        close.addClickHandler(new ClickHandler() {
            public void onClick(ClickEvent event) {
                UploadDialogBox.this.hide();
            }
        });

        final FileUpload upload = new FileUpload();
        upload.setName("uploadFormElement");
        upload.setId("uploadFormElement");
        Button submit = new Button();
        submit.setTitle("Upload file");
        submit.setIcon(IconType.UPLOAD_ALT);
        submit.setIconSize(IconSize.TWO_TIMES);
        submit.setStyle(new Style() {
            @Override
            public String get() {
                return "attachButton";
            }
        });
        submit.addClickHandler(new ClickHandler() {
            public void onClick(ClickEvent event) {
                upload.getElement().getStyle().setCursor(com.google.gwt.dom.client.Style.Cursor.WAIT);
                fileName = upload.getFilename();
               // Window.alert("FILE NAME " + fileName);
                if(   fileName.contains("/")   ){
                    fileName = fileName.substring(fileName.lastIndexOf("/") + 1 , fileName.length());
                }
                if(   fileName.contains("\\")   ){
                    fileName = fileName.substring(fileName.lastIndexOf("\\") + 1 , fileName.length());
                }
            //    messagesUI.setUplodaFileName(fileName);
                form.submit();
            }
        });


        form.addSubmitCompleteHandler(new FormPanel.SubmitCompleteHandler() {
            @Override
            public void onSubmitComplete(FormPanel.SubmitCompleteEvent event) {

             //   event.getAssociatedType();
               // Window.alert("event.getResults() " + event.getResults());
                messagesUI.setUplodaFileName(fileName + "@" + event.getResults());
                upload.getElement().getStyle().setCursor(com.google.gwt.dom.client.Style.Cursor.DEFAULT);
                UploadDialogBox.this.hide();
            }

         });

        hPanel.add(submit);
        hPanel.add(close);
        vPanel.add(upload);

        vPanel.add(hPanel);

        form.add(vPanel);

        setWidget(form);


    }


}
