package it.eng.edison.messages.client;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.Label;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.github.gwtbootstrap.client.ui.constants.LabelType;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;

/**
 * Created by Administrator on 14/07/2016.
 */
public class ConfirmDialogBox extends DialogBox {


    public interface ConfirmDialogCallback{

       boolean yesPressed();
       boolean noPressed();
    }

  //  public ConfirmDialogCallback confirmDialogCallback = null;

    public ConfirmDialogBox( String captionWidget , String text, final ConfirmDialogCallback confirmDialogCallback ) {

        setText(captionWidget);
        center();
        setModal(true);
        setAnimationEnabled(true);
        setGlassEnabled(true);

        HorizontalPanel buttonPanel = new HorizontalPanel();
        VerticalPanel mainPanel = new VerticalPanel();

        Label label = new Label(text);
        label.setType(LabelType.INFO);


        Button yesButton = new Button("Yes");
        yesButton.setIcon(IconType.OK);

        yesButton.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                hide();
                confirmDialogCallback.yesPressed();
            }
        });

        Button noButton = new Button("No");
        noButton.setIcon(IconType.REMOVE);

        noButton.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                hide();
                confirmDialogCallback.noPressed();
            }
        });

        buttonPanel.setSpacing(5);

        buttonPanel.add(yesButton);
        buttonPanel.add(noButton);
        mainPanel.add(label);
        mainPanel.add(buttonPanel);

        setWidget(mainPanel);
    }
}
