/*
 * Decompiled with CFR 0.152.
 */
package org.acme;

import java.util.Map;
import org.acme.HelloWorldPluginDeclaration;
import org.gcube.vremanagement.executor.exception.InputsNullException;
import org.gcube.vremanagement.executor.exception.InvalidInputsException;
import org.gcube.vremanagement.executor.plugin.Plugin;
import org.gcube.vremanagement.executor.plugin.PluginDeclaration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelloWorldPlugin
extends Plugin<HelloWorldPluginDeclaration> {
    private static Logger logger = LoggerFactory.getLogger(HelloWorldPlugin.class);
    public static final String SLEEP_TIME = "sleepTime";

    public HelloWorldPlugin(HelloWorldPluginDeclaration pluginDeclaration) {
        super((PluginDeclaration)pluginDeclaration);
        logger.debug("contructor");
    }

    public void launch(Map<String, Object> inputs) throws Exception {
        logger.debug("Launching HelloWorld");
        if (inputs == null) {
            throw new InputsNullException();
        }
        if (inputs.isEmpty() || !inputs.containsKey(SLEEP_TIME)) {
            logger.debug("HelloWorld inputs {} are not valid", inputs);
            throw new InvalidInputsException();
        }
        logger.debug("{} - Inputs : {}", (Object)((Object)((Object)this)).getClass().getSimpleName(), inputs);
        long sleepTime = (Long)inputs.get(SLEEP_TIME);
        Thread.sleep(sleepTime);
        logger.debug("HelloWorld finished");
    }

    protected void onStop() throws Exception {
        logger.debug("onStop()");
        Thread.currentThread().interrupt();
    }
}

