/*
 * Decompiled with CFR 0.152.
 */
package org.acme;

import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.xml.namespace.QName;
import org.cotrix.action.CodelistAction;
import org.cotrix.action.events.CodelistActionEvents;
import org.cotrix.application.VersioningService;
import org.cotrix.application.logbook.Logbook;
import org.cotrix.application.logbook.LogbookEvent;
import org.cotrix.application.logbook.LogbookService;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.domain.dsl.Data;
import org.cotrix.domain.dsl.Users;
import org.cotrix.domain.dsl.grammar.CodelistGrammar;
import org.cotrix.domain.user.User;
import org.cotrix.lifecycle.LifecycleEvent;
import org.cotrix.lifecycle.State;
import org.cotrix.lifecycle.impl.DefaultLifecycleStates;
import org.cotrix.repository.CodelistRepository;
import org.cotrix.repository.UserRepository;
import org.cotrix.test.ApplicationTest;
import org.cotrix.test.TestUser;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LogbookServiceTest
extends ApplicationTest {
    @Inject
    private LogbookService service;
    @Inject
    private CodelistRepository codelists;
    @Inject
    private UserRepository users;
    @Inject
    Event<CodelistActionEvents.CodelistEvent> events;
    @Inject
    Event<LifecycleEvent> lcEvents;
    @Inject
    VersioningService vservice;
    @Inject
    TestUser user;
    Codelist list = (Codelist)((CodelistGrammar.SecondClause)Data.codelist().name("mylist")).build();

    @Before
    public void before() {
        User fifi = Users.user().name("fifi").fullName("fifi").noMail().build();
        this.users.add((Object)fifi);
        this.user.set(fifi);
        this.codelists.add((Object)this.list);
    }

    @Test
    public void retrieveUnknownLogbook() {
        Assert.assertNull((Object)this.service.logbookOf("unknown"));
    }

    @Test
    public void logbooksAddedWhenCodelistsAre() {
        Logbook book = this.service.logbookOf(this.list.id());
        Assert.assertFalse((boolean)book.entries(LogbookEvent.CREATED).isEmpty());
    }

    @Test
    public void logbooksRemovedWhenCodelistsAre() {
        this.codelists.remove(this.list.id());
        Assert.assertNull((Object)this.service.logbookOf(this.list.id()));
    }

    @Test
    public void logbooksUpdatedWhenCodelistAreImported() {
        this.events.fire((Object)new CodelistActionEvents.Import("myrepo", this.list.id(), this.list.qname(), this.list.version(), null));
        Logbook book = this.service.logbookOf(this.list.id());
        Assert.assertFalse((boolean)book.entries(LogbookEvent.IMPORTED).isEmpty());
    }

    @Test
    public void logbooksUpdatedWhenCodelistArePublished() {
        this.events.fire((Object)new CodelistActionEvents.Publish(this.list.id(), this.list.qname(), this.list.version(), new QName("myrepo"), null));
        Logbook book = this.service.logbookOf(this.list.id());
        Assert.assertFalse((boolean)book.entries(LogbookEvent.PUBLISHED).isEmpty());
    }

    @Test
    public void logbooksUpdatedWhenCodelistAreVersioned() {
        Codelist versioned = this.vservice.bump(this.list).to("2");
        this.codelists.add((Object)versioned);
        Logbook book = this.service.logbookOf(this.list.id());
        Assert.assertFalse((boolean)book.entries(LogbookEvent.VERSIONED).isEmpty());
        book = this.service.logbookOf(versioned.id());
        Assert.assertFalse((boolean)book.entries(LogbookEvent.VERSIONED).isEmpty());
    }

    @Test
    public void logbooksUpdatedWhenCodelistChangeState() {
        this.lcEvents.fire((Object)new LifecycleEvent(this.list.id(), (State)DefaultLifecycleStates.draft, CodelistAction.LOCK.on(this.list.id()), (State)DefaultLifecycleStates.sealed));
        Logbook book = this.service.logbookOf(this.list.id());
        Assert.assertFalse((boolean)book.entries(LogbookEvent.LOCKED).isEmpty());
    }
}

