/*
 * Decompiled with CFR 0.152.
 */
package org.acme;

import javax.annotation.Priority;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.cotrix.application.MailService;
import org.cotrix.domain.dsl.Roles;
import org.cotrix.domain.dsl.Users;
import org.cotrix.domain.user.User;
import org.cotrix.repository.UserRepository;
import org.cotrix.security.SignupService;
import org.cotrix.test.ApplicationTest;
import org.junit.Test;
import org.mockito.Mockito;

@Priority(value=0x7FFFFFFF)
public class MailerTest
extends ApplicationTest {
    @Inject
    MailService service;
    @Inject
    SignupService signupService;
    @Inject
    UserRepository repository;

    @Produces
    @Alternative
    @Singleton
    static MailService mockIt() {
        return (MailService)Mockito.mock(MailService.class);
    }

    @Test
    public void mailOnSignup() {
        User user = Users.user().name("fifi").fullName("fifi").email("fifi@me.com").build();
        this.repository.add((Object)Roles.role((String)"some").isRoot().build());
        this.signupService.signup(user, "any");
        ((MailService)Mockito.verify((Object)this.service)).sendMessage(Mockito.anyCollectionOf(String.class), Mockito.anyString(), Mockito.anyString());
    }
}

