/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.application.impl.delegation;

import java.util.Collection;
import java.util.HashSet;
import javax.inject.Inject;
import org.cotrix.action.Action;
import org.cotrix.application.DelegationPolicy;
import org.cotrix.application.PermissionDelegationService;
import org.cotrix.common.CommonUtils;
import org.cotrix.common.events.Current;
import org.cotrix.domain.dsl.Users;
import org.cotrix.domain.user.Role;
import org.cotrix.domain.user.User;
import org.cotrix.repository.UserRepository;

public class DefaultDelegationService
implements PermissionDelegationService {
    private final User currentUser;
    private final DelegationPolicy policy;
    private final UserRepository repository;

    @Inject
    public DefaultDelegationService(@Current User user, UserRepository repository, DelegationPolicy policy) {
        CommonUtils.notNull((String)"current user", (Object)user);
        CommonUtils.notNull((String)"user repository", (Object)repository);
        CommonUtils.notNull((String)"delegation policy", (Object)policy);
        this.currentUser = user;
        this.repository = repository;
        this.policy = policy;
    }

    @Override
    public PermissionDelegationService.DelegateClause delegate(final Action ... actions) {
        return new PermissionDelegationService.DelegateClause(){

            @Override
            public void to(User user) {
                DefaultDelegationService.this.validate(user);
                DefaultDelegationService.this.policy.validateDelegation(DefaultDelegationService.this.currentUser, user, actions);
                User changeset = Users.modifyUser((User)user).can(actions).build();
                DefaultDelegationService.this.repository.update((Object)changeset);
            }
        };
    }

    @Override
    public PermissionDelegationService.DelegateClause delegate(Collection<Action> actions) {
        return this.delegate(actions.toArray(new Action[0]));
    }

    @Override
    public PermissionDelegationService.DelegateClause delegate(final Role ... roles) {
        return new PermissionDelegationService.DelegateClause(){

            @Override
            public void to(User user) {
                DefaultDelegationService.this.validate(user);
                DefaultDelegationService.this.policy.validateDelegation(DefaultDelegationService.this.currentUser, user, roles);
                User changeset = Users.modifyUser((User)user).is(roles).build();
                DefaultDelegationService.this.repository.update((Object)changeset);
            }
        };
    }

    @Override
    public PermissionDelegationService.RevokeClause revoke(final Action ... actions) {
        return new PermissionDelegationService.RevokeClause(){

            @Override
            public void from(User user) {
                DefaultDelegationService.this.validate(user);
                for (Action p : actions) {
                    if (user.permissions().contains(p)) continue;
                    throw new IllegalStateException(user.name() + " does not have permission " + p);
                }
                DefaultDelegationService.this.policy.validateRevocation(DefaultDelegationService.this.currentUser, user, actions);
                User changeset = Users.modifyUser((User)user).cannot(actions).build();
                DefaultDelegationService.this.repository.update((Object)changeset);
            }
        };
    }

    @Override
    public PermissionDelegationService.RevokeClause revoke(final Role ... roles) {
        return new PermissionDelegationService.RevokeClause(){

            @Override
            public void from(User user) {
                DefaultDelegationService.this.validate(user);
                DefaultDelegationService.this.policy.validateRevocation(DefaultDelegationService.this.currentUser, user, roles);
                HashSet parents = new HashSet();
                for (Role role : roles) {
                    parents.addAll(role.directRoles());
                }
                User changeset = Users.modifyUser((User)user).isNoLonger(roles).is(parents).build();
                if (changeset.directRoles().isEmpty()) {
                    DefaultDelegationService.this.repository.remove(user.id());
                } else {
                    DefaultDelegationService.this.repository.update((Object)changeset);
                }
            }
        };
    }

    @Override
    public PermissionDelegationService.RevokeClause revoke(Collection<Action> actions) {
        return this.revoke(actions.toArray(new Action[0]));
    }

    private void validate(User u) {
        if (u.id() == null) {
            throw new IllegalArgumentException("cannot delegate roles to unidentified user " + u);
        }
    }

    Action[] toArray(Collection<Action> actions) {
        return actions.toArray(new Action[0]);
    }
}

