/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.common;

import com.google.gson.Gson;
import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;

public class CommonUtils {
    private static final XStream stream = new XStream();
    private static final Gson jsonStream = new Gson();
    private static final String EMAIL_PATTERN = "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
    private static final Pattern pattern = Pattern.compile("^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$");

    public static String time() {
        return DateFormat.getDateTimeInstance().format(Calendar.getInstance().getTime());
    }

    public static Date time(String time) {
        try {
            return DateFormat.getDateTimeInstance().parse(time);
        }
        catch (ParseException e) {
            throw CommonUtils.unchecked("invalid date format", e);
        }
    }

    public static XStream binder() {
        return stream;
    }

    public static Gson jsonBinder() {
        return jsonStream;
    }

    public static void verify(String msg, boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException(msg);
        }
    }

    public static void notNull(String name, Object o) throws IllegalArgumentException {
        CommonUtils.verify(name + " is null", o != null);
    }

    public static void notEmpty(String name, String s) throws IllegalArgumentException {
        CommonUtils.notNull(name, s);
        CommonUtils.verify(name + " is empty", !s.isEmpty());
    }

    public static void valid(String name, String s) throws IllegalArgumentException {
        CommonUtils.notNull(name, s);
        CommonUtils.notEmpty(name, s);
    }

    public static void positive(String name, int val) throws IllegalArgumentException {
        CommonUtils.verify(name + " is not positive", val > 0);
    }

    public static void notNulls(String name, Object[] o) throws IllegalArgumentException {
        CommonUtils.notNull(name, o);
        for (Object ob : o) {
            CommonUtils.notNull("one of " + name, ob);
        }
    }

    public static void notEmpty(String name, Collection<? extends Object> c) throws IllegalArgumentException {
        CommonUtils.notNull(name, c);
        CommonUtils.verify(name + " is empty", !c.isEmpty());
    }

    public static void notEmpty(String name, Object[] a) throws IllegalArgumentException {
        CommonUtils.notNull(name, a);
        CommonUtils.verify(name + " is empty", a.length > 0);
    }

    public static void valid(String name, Object[] a) throws IllegalArgumentException {
        CommonUtils.notNull(name, a);
        for (Object e : a) {
            CommonUtils.notNull(name + "'s element", e);
        }
    }

    public static void valid(String name, Collection<String> c) throws IllegalArgumentException {
        CommonUtils.notNull(name, c);
        CommonUtils.notEmpty(name, c);
        for (String e : c) {
            CommonUtils.valid(name + "'s element", e);
        }
    }

    public static void valid(File file) throws IllegalArgumentException {
        CommonUtils.notNull("file", file);
        CommonUtils.verify(file + " does not exist, is a directory, or cannot be read", file.exists() && file.isDirectory() && file.canRead());
    }

    public static void validDirectory(File dir) throws IllegalArgumentException {
        CommonUtils.notNull("directory", dir);
        CommonUtils.verify(dir + " does not exist or cannot be read", dir.exists() && dir.canRead());
    }

    public static boolean isValid(File file) {
        CommonUtils.notNull("file", file);
        return file.exists() && file.isDirectory() && file.canRead();
    }

    public static boolean isValidDirectory(File dir) {
        CommonUtils.notNull("directory", dir);
        return dir.exists() && dir.canRead();
    }

    public static void validEmail(String email) {
        CommonUtils.verify("invalid email address " + email, pattern.matcher(email).matches());
    }

    public static void valid(String text, QName name) throws IllegalArgumentException {
        CommonUtils.notNull(text, name);
        CommonUtils.valid(text, name.getLocalPart());
    }

    public static <T> T reveal(Object o, Class<T> type) {
        CommonUtils.notNull("object", o);
        try {
            return type.cast(o);
        }
        catch (ClassCastException e) {
            throw new AssertionError((Object)("expected a " + type + ", found instead a " + o.getClass()));
        }
    }

    public static <PUBLIC, PRIVATE extends PUBLIC> List<PRIVATE> revealAll(Iterable<? extends PUBLIC> objects, Class<PRIVATE> privateClass) {
        CommonUtils.notNull("objects", objects);
        ArrayList<PRIVATE> privates = new ArrayList<PRIVATE>();
        for (PUBLIC publicObject : objects) {
            privates.add(CommonUtils.reveal(publicObject, privateClass));
        }
        return privates;
    }

    public static RuntimeException unchecked(Throwable t) {
        return CommonUtils.unchecked(t.getMessage() + "( unchecked wrapper )", t);
    }

    public static RuntimeException unchecked(String msg, Throwable t) {
        return t instanceof RuntimeException ? (RuntimeException)RuntimeException.class.cast(t) : new RuntimeException(msg, t);
    }

    public static void rethrowUnchecked(Throwable t) throws RuntimeException {
        throw CommonUtils.unchecked(t);
    }

    public static void rethrow(String msg, Throwable t) throws RuntimeException {
        throw CommonUtils.unchecked(msg, t);
    }

    public static <T> Collection<T> collect(Iterator<T> it) {
        ArrayList<T> c = new ArrayList<T>();
        while (it.hasNext()) {
            c.add(it.next());
        }
        return c;
    }

    public static <T> Collection<T> collect(Iterable<T> it) {
        ArrayList<T> c = new ArrayList<T>();
        for (T t : it) {
            c.add(t);
        }
        return c;
    }

    public static <T> Set<T> collectUnordered(Iterable<T> it) {
        HashSet<T> c = new HashSet<T>();
        for (T t : it) {
            c.add(t);
        }
        return c;
    }

    public static <T> int count(Iterable<T> elements) {
        return CommonUtils.count(elements.iterator());
    }

    public static <T> int count(Iterator<T> elements) {
        int count = 0;
        while (elements.hasNext()) {
            elements.next();
            ++count;
        }
        return count;
    }

    public static void assertEqualUnordered(Collection<?> c1, Object ... ts) {
        HashSet s1 = new HashSet(c1);
        HashSet<Object> s2 = new HashSet<Object>(Arrays.asList(ts));
        if (!s2.equals(s1)) {
            throw new AssertionError((Object)("expected " + s2 + " but was " + s1));
        }
    }

    public static void assertEqualOrdered(Collection<?> c1, Object ... ts) {
        ArrayList s1 = new ArrayList(c1);
        List<Object> s2 = Arrays.asList(ts);
        if (!s2.equals(s1)) {
            throw new AssertionError((Object)("expected " + s2 + " but was " + s1));
        }
    }
}

