/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.common;

import java.util.ArrayList;
import java.util.List;
import org.cotrix.common.CommonUtils;
import org.cotrix.common.Log;

public class Report {
    private static InheritableThreadLocal<Report> reports = new InheritableThreadLocal<Report>(){

        @Override
        protected Report initialValue() {
            return new Report();
        }
    };
    private final double start = System.currentTimeMillis();
    private List<Item> items = new ArrayList<Item>();
    private boolean failure;

    public static Report report() {
        return (Report)reports.get();
    }

    public List<Item> logs() {
        return this.items;
    }

    public TypeClause log(String msg) {
        return this.log(Log.item(msg));
    }

    public TypeClause log(final Item item) {
        CommonUtils.notNull("item", item);
        item.time(this.time());
        this.items.add(item);
        return new TypeClause(){

            @Override
            public Report as(Item.Type type) {
                item.type(type);
                if (type == Item.Type.ERROR) {
                    Report.this.failure = true;
                }
                return Report.this;
            }
        };
    }

    public void close() {
        reports.remove();
    }

    public boolean isFailure() {
        return this.failure;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Item item : this.items) {
            builder.append((Object)((Object)item.type()) + ":").append(" (" + item.time() + "s) ").append(item.message()).append("\n");
        }
        return builder.toString();
    }

    public String time() {
        return String.valueOf(((double)System.currentTimeMillis() - this.start) / 1000.0);
    }

    public static interface TypeClause {
        public Report as(Item.Type var1);
    }

    public static abstract class Item {
        private Type type = Type.INFO;
        private String time;

        public abstract String message();

        public void time(String time) {
            this.time = time;
        }

        public String time() {
            return this.time;
        }

        public Type type() {
            return this.type;
        }

        public void type(Type type) {
            this.type = type;
        }

        public <T extends Item> T as(Class<T> type) {
            return (T)((Item)type.cast(this));
        }

        public static enum Type {
            WARN,
            ERROR,
            INFO;

        }
    }
}

