/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.memory;

import java.util.Collection;
import org.cotrix.common.Utils;
import org.cotrix.domain.codelist.Code;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.domain.codelist.CodelistLink;
import org.cotrix.domain.common.NamedStateContainer;
import org.cotrix.domain.memory.CodeMS;
import org.cotrix.domain.memory.CodelistLinkMS;
import org.cotrix.domain.memory.VersionedMS;
import org.cotrix.domain.trait.Status;

public final class CodelistMS
extends VersionedMS
implements Codelist.State {
    private NamedStateContainer<Code.State> codes = new NamedStateContainer.Default<Code.State>();
    private NamedStateContainer<CodelistLink.State> links = new NamedStateContainer.Default<CodelistLink.State>();

    public CodelistMS() {
    }

    public CodelistMS(String id, Status status) {
        super(id, status);
    }

    public CodelistMS(Codelist.State state) {
        super(state);
        for (Code.State code : state.codes()) {
            this.codes.add(new CodeMS(code));
        }
        for (CodelistLink.State link : state.links()) {
            this.links.add(new CodelistLinkMS(link));
        }
    }

    @Override
    public NamedStateContainer<CodelistLink.State> links() {
        return this.links;
    }

    public void links(Collection<CodelistLink.State> links) {
        Utils.notNull((String)"links", links);
        for (CodelistLink.State link : links) {
            this.links.add(link);
        }
    }

    public void codes(Collection<Code.State> codes) {
        Utils.notNull((String)"codes", codes);
        for (Code.State code : codes) {
            this.codes.add(code);
        }
    }

    @Override
    public NamedStateContainer<Code.State> codes() {
        return this.codes;
    }

    @Override
    public Codelist.Private entity() {
        return new Codelist.Private(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Codelist.State)) {
            return false;
        }
        Codelist.State other = (Codelist.State)obj;
        if (this.codes == null ? other.codes() != null : !this.codes.equals(other.codes())) {
            return false;
        }
        return !(this.links == null ? other.links() != null : !this.links.equals(other.links()));
    }
}

