/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.memory;

import org.cotrix.common.Utils;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.domain.codelist.CodelistLink;
import org.cotrix.domain.links.NameLink;
import org.cotrix.domain.links.OccurrenceRange;
import org.cotrix.domain.links.OccurrenceRanges;
import org.cotrix.domain.links.ValueFunction;
import org.cotrix.domain.links.ValueFunctions;
import org.cotrix.domain.links.ValueType;
import org.cotrix.domain.memory.NamedMS;
import org.cotrix.domain.trait.Status;

public class CodelistLinkMS
extends NamedMS
implements CodelistLink.State {
    private Codelist.State target;
    private ValueType type;
    private ValueFunction function;
    private OccurrenceRange range;

    public CodelistLinkMS() {
        this.valueType(NameLink.INSTANCE);
        this.function(ValueFunctions.identity);
        this.range(OccurrenceRanges.arbitrarily);
    }

    public CodelistLinkMS(String id, Status status) {
        super(id, status);
    }

    public CodelistLinkMS(CodelistLink.State state) {
        super(state);
        this.target(state.target());
        this.valueType(state.valueType());
        this.range(state.range());
        this.function(state.function());
    }

    @Override
    public ValueType valueType() {
        return this.type;
    }

    @Override
    public void valueType(ValueType type) {
        Utils.notNull((String)"link type", (Object)type);
        this.type = type;
    }

    @Override
    public OccurrenceRange range() {
        return this.range;
    }

    @Override
    public void range(OccurrenceRange range) {
        Utils.notNull((String)"occurrence range", (Object)range);
        this.range = range;
    }

    @Override
    public ValueFunction function() {
        return this.function;
    }

    @Override
    public void function(ValueFunction function) {
        Utils.notNull((String)"value function", (Object)function);
        this.function = function;
    }

    @Override
    public Codelist.State target() {
        return this.target;
    }

    @Override
    public void target(Codelist.State list) {
        Utils.notNull((String)"list", (Object)list);
        this.target = list;
    }

    @Override
    public CodelistLink.Private entity() {
        return new CodelistLink.Private(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.function == null ? 0 : this.function.hashCode());
        result = 31 * result + (this.range == null ? 0 : this.range.hashCode());
        result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof CodelistLink.State)) {
            return false;
        }
        CodelistLink.State other = (CodelistLink.State)obj;
        if (this.function == null ? other.function() != null : !this.function.equals(other.function())) {
            return false;
        }
        if (this.range == null ? other.range() != null : !this.range.equals(other.range())) {
            return false;
        }
        if (this.target == null ? other.target() != null : !this.target.equals(other.target())) {
            return false;
        }
        return !(this.type == null ? other.valueType() != null : !this.type.equals(other.valueType()));
    }
}

