/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.dsl.builder;

import java.util.Arrays;
import java.util.List;
import org.cotrix.common.Utils;
import org.cotrix.domain.codelist.Code;
import org.cotrix.domain.codelist.Codelink;
import org.cotrix.domain.codelist.CodelistLink;
import org.cotrix.domain.common.Attribute;
import org.cotrix.domain.dsl.Codes;
import org.cotrix.domain.dsl.builder.BuilderUtils;
import org.cotrix.domain.dsl.grammar.CodelinkGrammar;
import org.cotrix.domain.dsl.grammar.CommonClauses;
import org.cotrix.domain.memory.CodelinkMS;

public class CodelinkBuilder
implements CodelinkGrammar.OptionalClause,
CommonClauses.LinkTargetClause<Code, CodelinkGrammar.OptionalClause>,
CodelinkGrammar.CodelinkChangeClause {
    private final CodelinkMS state;

    public CodelinkBuilder(CodelinkMS state) {
        this.state = state;
    }

    @Override
    public CodelinkGrammar.OptionalClause target(Code code) {
        Utils.notNull((String)"code", (Object)code);
        Code.Private privatecode = Codes.reveal(code);
        if (privatecode.isChangeset()) {
            throw new IllegalArgumentException("invalid link: target code cannot be a changeset");
        }
        Code.State target = (Code.State)privatecode.state();
        this.state.target(target);
        return this;
    }

    @Override
    public CodelinkGrammar.OptionalClause attributes(Attribute ... attributes) {
        return this.attributes((List)Arrays.asList(attributes));
    }

    @Override
    public CodelinkGrammar.OptionalClause attributes(List<Attribute> attributes) {
        this.state.attributes(BuilderUtils.reveal(attributes, Attribute.Private.class));
        return this;
    }

    @Override
    public Codelink build() {
        return this.state.entity();
    }

    public class NewClause
    implements CodelinkGrammar.CodelinkNewClause {
        @Override
        public CommonClauses.LinkTargetClause<Code, CodelinkGrammar.OptionalClause> instanceOf(CodelistLink linktype) {
            CodelistLink.Private type = Codes.reveal(linktype);
            if (type.isChangeset()) {
                throw new IllegalArgumentException("invalid link: link type cannot be a changeset");
            }
            CodelinkBuilder.this.state.type((CodelistLink.State)type.state());
            return CodelinkBuilder.this;
        }
    }
}

