/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.utils;

import java.text.DateFormat;
import java.util.Calendar;
import javax.xml.namespace.QName;
import org.cotrix.domain.common.Attribute;
import org.cotrix.domain.dsl.Codes;
import org.cotrix.domain.memory.AttributeMS;
import org.cotrix.domain.version.Version;

public class Constants {
    public static final String NS = "http://cotrix.org";
    public static final QName DESCRIPTION_TYPE = Codes.q("http://cotrix.org", "description");
    public static final QName ANNOTATION_TYPE = Codes.q("http://cotrix.org", "annotation");
    public static final QName NAME_TYPE = Codes.q("http://cotrix.org", "name");
    public static final QName OTHER_CODE_TYPE = Codes.q("http://cotrix.org", "other_code");
    public static final QName OTHER_TYPE = Codes.q("http://cotrix.org", "other");
    public static final QName DEFAULT_TYPE = DESCRIPTION_TYPE;
    public static final QName SYSTEM_TYPE = Codes.q("http://cotrix.org", "system");
    public static final QName NAME = Codes.q("http://cotrix.org", "name");
    public static final QName CREATION_TIME = Codes.q("http://cotrix.org", "created");
    public static final QName UPDATE_TIME = Codes.q("http://cotrix.org", "updated");
    public static final QName PREVIOUS_VERSION = Codes.q("http://cotrix.org", "previous_version");
    public static final QName PREVIOUS_VERSION_ID = Codes.q("http://cotrix.org", "previous_version_id");
    public static final QName PREVIOUS_VERSION_NAME = Codes.q("http://cotrix.org", "previous_version_name");
    public static final String UNDEFINED_LINK_VALUE = "_!!_undefined_!!_";
    public static final String NULL_STRING = "__ignore__";
    public static final QName NULL_QNAME = Codes.q("__ignore__");
    public static final String NO_MAIL = "no@cotrix.mail";

    public static Attribute.State timestamp(QName name) {
        return Constants.systemAttribute(name, DateFormat.getDateTimeInstance().format(Calendar.getInstance().getTime()));
    }

    public static Attribute.State previousName(QName name) {
        return Constants.systemAttribute(PREVIOUS_VERSION_NAME, name.toString());
    }

    public static Attribute.State previousId(String id) {
        return Constants.systemAttribute(PREVIOUS_VERSION_ID, id);
    }

    public static Attribute.State previousVersion(Version version) {
        return Constants.systemAttribute(PREVIOUS_VERSION, version.value());
    }

    private static Attribute.State systemAttribute(QName name, String value) {
        AttributeMS a = new AttributeMS();
        a.name(name);
        a.type(SYSTEM_TYPE);
        a.value(value);
        return a;
    }
}

