/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.attributes;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.cotrix.domain.attributes.Definition;
import org.cotrix.domain.dsl.Codes;
import org.cotrix.domain.dsl.grammar.DefinitionGrammar;
import org.cotrix.domain.utils.Constants;

public enum CommonDefinition {
    CREATION_TIME(CommonDefinition.make("created")),
    UPDATE_TIME(CommonDefinition.make("updated")),
    UPDATED_BY(CommonDefinition.make("updatedBy")),
    STATUS(CommonDefinition.make("status")),
    PREV_VERSION(CommonDefinition.make("previous_version")),
    PREV_VERSION_ID(CommonDefinition.make("previous_version_id")),
    PREV_VERSION_NAME(CommonDefinition.make("previous_version_name"));

    private static Map<QName, CommonDefinition> defs;
    private final Definition def;

    private CommonDefinition(Definition def) {
        this.def = def;
    }

    public QName qname() {
        return this.def.name();
    }

    public Definition get() {
        return this.def;
    }

    public Definition.State state() {
        return (Definition.State)Codes.reveal(this.def).state();
    }

    public static boolean isCommon(QName name) {
        return defs.get(name) != null;
    }

    public static CommonDefinition commonDefinitionFor(QName name) {
        return defs.get(name);
    }

    private static Definition make(String name) {
        return (Definition)((DefinitionGrammar.OptionalClause)Codes.definition().name(Codes.q("http://cotrix.org", name))).is(Constants.SYSTEM_TYPE).build();
    }

    static {
        defs = new HashMap<QName, CommonDefinition>();
        for (CommonDefinition def : CommonDefinition.values()) {
            defs.put(def.qname(), def);
        }
    }
}

