/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.dsl.builder;

import java.util.Arrays;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.cotrix.domain.attributes.Attribute;
import org.cotrix.domain.codelist.Code;
import org.cotrix.domain.codelist.Codelink;
import org.cotrix.domain.dsl.Codes;
import org.cotrix.domain.dsl.builder.BuilderUtils;
import org.cotrix.domain.dsl.grammar.CodeGrammar;
import org.cotrix.domain.memory.CodeMS;

public final class CodeBuilder
implements CodeGrammar.CodeNewClause,
CodeGrammar.CodeChangeClause {
    private final CodeMS state;

    public CodeBuilder(CodeMS state) {
        this.state = state;
    }

    @Override
    public CodeGrammar.OptionalClause name(QName name) {
        this.state.name(name);
        return this;
    }

    @Override
    public CodeGrammar.OptionalClause name(String name) {
        return this.name(Codes.q(name));
    }

    public CodeBuilder links(Codelink ... links) {
        return this.links(Arrays.asList(links));
    }

    @Override
    public CodeBuilder links(Collection<Codelink> links) {
        this.state.links(BuilderUtils.reveal(links, Codelink.Private.class));
        return this;
    }

    @Override
    public CodeBuilder attributes(Attribute ... attributes) {
        return this.attributes(Arrays.asList(attributes));
    }

    @Override
    public CodeBuilder attributes(Collection<Attribute> attributes) {
        this.state.attributes(BuilderUtils.reveal(attributes, Attribute.Private.class));
        return this;
    }

    @Override
    public Code build() {
        return this.state.entity();
    }
}

