/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.attributes;

import javax.xml.namespace.QName;
import org.cotrix.domain.attributes.AttributeDefinition;
import org.cotrix.domain.attributes.Facet;
import org.cotrix.domain.trait.BeanOf;
import org.cotrix.domain.trait.Defined;
import org.cotrix.domain.trait.Identified;
import org.cotrix.domain.trait.Named;
import org.cotrix.domain.utils.DomainConstants;

public interface Attribute
extends Identified,
Named,
Defined<AttributeDefinition> {
    public QName type();

    public boolean is(QName var1);

    public boolean is(Facet var1);

    public String value();

    public String language();

    public String note();

    public static final class Private
    extends Named.Private<Private, Bean>
    implements Attribute {
        public Private(Bean state) {
            super(state);
        }

        @Override
        public AttributeDefinition definition() {
            return (AttributeDefinition)((AttributeDefinition.Bean)((Bean)this.bean()).definition()).entity();
        }

        @Override
        public QName type() {
            return ((Bean)this.bean()).type();
        }

        @Override
        public boolean is(QName type) {
            return ((Bean)this.bean()).is(type);
        }

        @Override
        public boolean is(Facet facet) {
            return ((Bean)this.bean()).is(facet);
        }

        @Override
        public String value() {
            return ((Bean)this.bean()).value();
        }

        @Override
        public String language() {
            return ((Bean)this.bean()).language();
        }

        @Override
        public String note() {
            return ((Bean)this.bean()).note();
        }

        @Override
        public void update(Private changeset) throws IllegalArgumentException, IllegalStateException {
            super.update(changeset);
            if (changeset.value() != null) {
                ((Bean)this.bean()).value(changeset.value() == "__ignore__" ? null : changeset.value());
            }
            if (changeset.qname() == DomainConstants.NULL_QNAME) {
                throw new IllegalArgumentException("attribute name " + this.qname() + " cannot be erased");
            }
            if (changeset.qname() != null) {
                ((Bean)this.bean()).qname(changeset.qname());
            }
            if (changeset.type() == DomainConstants.NULL_QNAME) {
                throw new IllegalArgumentException("attribute type " + this.type() + " cannot be erased");
            }
            if (changeset.type() != null) {
                ((Bean)this.bean()).type(changeset.type());
            }
            if (changeset.language() != null) {
                ((Bean)this.bean()).language(changeset.language() == "__ignore__" ? null : changeset.language());
            }
            if (changeset.note() != null) {
                ((Bean)this.bean()).note(changeset.note() == "__ignore__" ? null : changeset.note());
            }
        }

        public String toString() {
            return "attr [id=" + this.id() + ", value=" + this.value() + ", def=" + this.definition() + (this.status() == null ? "" : " (" + (Object)((Object)this.status()) + ") ") + "]";
        }
    }

    public static interface Bean
    extends Named.Bean,
    Defined.Bean<AttributeDefinition.Bean>,
    BeanOf<Private> {
        public QName type();

        public void type(QName var1);

        public String value();

        public void value(String var1);

        public String language();

        public void language(String var1);

        public String note();

        public void note(String var1);

        public boolean is(QName var1);

        public boolean is(Facet var1);
    }
}

