/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.dsl.builder;

import java.util.Collection;
import org.cotrix.action.Action;
import org.cotrix.action.ResourceType;
import org.cotrix.common.CommonUtils;
import org.cotrix.domain.dsl.Roles;
import org.cotrix.domain.dsl.grammar.UserGrammar;
import org.cotrix.domain.memory.MUser;
import org.cotrix.domain.user.DefaultRole;
import org.cotrix.domain.user.Role;
import org.cotrix.domain.user.User;

public class UserBuilder
implements UserGrammar.UserNewClause,
UserGrammar.UserChangeClause {
    private final MUser state;

    public UserBuilder(MUser state) {
        this.state = state;
    }

    @Override
    public UserBuilder name(String name) {
        CommonUtils.valid((String)"user name", (String)name);
        this.state.name(name);
        return this;
    }

    @Override
    public UserGrammar.ThirdClause email(String email) {
        CommonUtils.notNull((String)"email", (Object)email);
        this.state.email(email);
        return this;
    }

    @Override
    public UserGrammar.ThirdClause noMail() {
        return this.email("no@cotrix.mail");
    }

    @Override
    public UserBuilder can(Action ... actions) {
        CommonUtils.valid((String)"actions", (Object[])actions);
        for (Action action : actions) {
            this.state.add(action);
        }
        return this;
    }

    @Override
    public UserGrammar.ThirdClause isRoot() {
        return this.is(Roles.ROOT);
    }

    @Override
    public UserBuilder is(Role ... roles) {
        CommonUtils.valid((String)"roles", (Object[])roles);
        for (Role role : roles) {
            this.state.add(role);
        }
        return this;
    }

    @Override
    public UserBuilder is(Collection<Role> roles) {
        return this.is(roles.toArray(new DefaultRole[0]));
    }

    @Override
    public UserGrammar.UserChangeClause isNoLonger(Role ... roles) {
        CommonUtils.valid((String)"roles", (Object[])roles);
        for (Role role : roles) {
            this.state.remove(role);
        }
        return this;
    }

    @Override
    public UserGrammar.UserChangeClause isNoLonger(Collection<Role> roles) {
        return this.isNoLonger(roles.toArray(new DefaultRole[0]));
    }

    @Override
    public UserBuilder can(Collection<Action> actions) {
        return this.can(actions.toArray(new Action[0]));
    }

    @Override
    public UserBuilder cannot(Action ... actions) {
        CommonUtils.valid((String)"actions", (Object[])actions);
        for (Action action : actions) {
            this.state.remove(action);
        }
        return this;
    }

    @Override
    public UserBuilder fullName(String name) {
        CommonUtils.valid((String)"user's full name", (String)name);
        this.state.fullName(name);
        return this;
    }

    @Override
    public User build() {
        return this.state.entity();
    }

    @Override
    public Role buildAsRoleFor(ResourceType type) {
        return new DefaultRole(new User.Private(this.state), type);
    }
}

