/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.links;

import org.cotrix.domain.codelist.Codelist;
import org.cotrix.domain.links.LinkValueType;
import org.cotrix.domain.trait.BeanOf;
import org.cotrix.domain.trait.Definition;
import org.cotrix.domain.trait.Described;
import org.cotrix.domain.values.ValueFunction;

public interface LinkDefinition
extends Described,
Definition {
    public Codelist target();

    public LinkValueType valueType();

    public ValueFunction function();

    public static class Private
    extends Definition.Private<Private, Bean>
    implements LinkDefinition {
        public Private(Bean state) {
            super(state);
        }

        @Override
        public Codelist target() {
            return ((Bean)this.bean()).target() == null ? null : new Codelist.Private(((Bean)this.bean()).target());
        }

        @Override
        public LinkValueType valueType() {
            return ((Bean)this.bean()).valueType();
        }

        @Override
        public ValueFunction function() {
            return ((Bean)this.bean()).function();
        }

        @Override
        public void update(Private changeset) throws IllegalArgumentException, IllegalStateException {
            ValueFunction newfunction;
            super.update(changeset);
            LinkValueType newtype = ((Bean)changeset.bean()).valueType();
            if (newtype != null) {
                ((Bean)this.bean()).valueType(newtype);
            }
            if ((newfunction = ((Bean)changeset.bean()).function()) != null) {
                ((Bean)this.bean()).function(newfunction);
            }
        }
    }

    public static interface Bean
    extends Definition.Bean,
    BeanOf<Private> {
        public Codelist.Bean target();

        public LinkValueType valueType();

        public void valueType(LinkValueType var1);

        public ValueFunction function();

        public void function(ValueFunction var1);

        public void target(Codelist.Bean var1);
    }
}

