/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.memory;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.cotrix.common.CommonUtils;
import org.cotrix.domain.attributes.Attribute;
import org.cotrix.domain.attributes.AttributeDefinition;
import org.cotrix.domain.attributes.Facet;
import org.cotrix.domain.common.Status;
import org.cotrix.domain.memory.MAttrDef;
import org.cotrix.domain.memory.MIdentified;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MAttribute
extends MIdentified
implements Attribute.Bean {
    private static final Logger log = LoggerFactory.getLogger(Attribute.class);
    private String value;
    private String note;
    private AttributeDefinition.Bean definition = new MAttrDef(false);

    public MAttribute() {
    }

    public MAttribute(String id, Status status) {
        super(id, status);
        this.type(null);
    }

    public MAttribute(Attribute.Bean other) {
        this(other, new HashMap<String, Object>());
    }

    public MAttribute(Attribute.Bean other, Map<String, Object> defs) {
        super(other.id());
        this.definition(this.cloneDefinitionInContext((AttributeDefinition.Bean)other.definition(), defs));
        this.value(other.value());
        this.note(other.note());
    }

    @Override
    public AttributeDefinition.Bean definition() {
        return this.definition;
    }

    @Override
    public void definition(AttributeDefinition.Bean definition) {
        CommonUtils.notNull((String)"definition", (Object)definition);
        this.definition = definition;
        this.value(definition.valueType().defaultValue());
    }

    @Override
    public QName qname() {
        return this.definition.qname();
    }

    @Override
    public void qname(QName name) {
        this.definition.qname(name);
    }

    @Override
    public QName type() {
        return this.definition.type();
    }

    @Override
    public boolean is(QName name) {
        return this.definition.is(name);
    }

    @Override
    public boolean is(Facet facet) {
        return this.definition.is(facet);
    }

    @Override
    public String value() {
        return this.value;
    }

    @Override
    public void type(QName type) {
        this.definition.type(type);
    }

    @Override
    public void value(String value) {
        this.value = value;
    }

    @Override
    public String language() {
        return this.definition.language();
    }

    @Override
    public void language(String language) {
        this.definition.language(language);
    }

    @Override
    public String note() {
        return this.note;
    }

    @Override
    public void note(String note) {
        this.note = note;
    }

    @Override
    public Attribute.Private entity() {
        return new Attribute.Private(this);
    }

    private AttributeDefinition.Bean cloneDefinitionInContext(AttributeDefinition.Bean def, Map<String, Object> context) {
        if (!def.isShared()) {
            return new MAttrDef(def);
        }
        if (context == null) {
            log.error("cannot share definition '{}' during copy, as there is no context", (Object)def.qname());
            return new MAttrDef(def);
        }
        if (!context.containsKey(def.id())) {
            throw new AssertionError((Object)("application error: definition '" + def.qname() + "' cannot be shared during copy"));
        }
        return (AttributeDefinition.Bean)context.get(def.id());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        Attribute.Bean other = (Attribute.Bean)obj;
        if (this.definition == null ? other.definition() != null : !this.definition.equals(other.definition())) {
            return false;
        }
        return !(this.value == null ? other.value() != null : !this.value.equals(other.value()));
    }
}

