/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.trait;

import org.cotrix.common.CommonUtils;
import org.cotrix.domain.common.Status;

public interface Identified {
    public String id();

    public static abstract class Private<SELF extends Private<SELF, B>, B extends Bean>
    implements Identified {
        private B bean;

        public Private(B bean) {
            CommonUtils.notNull((String)"bean", bean);
            this.bean = bean;
        }

        public B bean() {
            return this.bean;
        }

        @Override
        public String id() {
            return this.bean.id();
        }

        public boolean isChangeset() {
            return this.status() == Status.MODIFIED || this.status() == Status.DELETED;
        }

        public Status status() {
            return this.bean.status();
        }

        public void update(SELF changeset) throws IllegalArgumentException, IllegalStateException {
            CommonUtils.notNull((String)"changeset", changeset);
            if (this.isChangeset()) {
                throw new IllegalStateException("entity " + this.bean.id() + "(" + this.getClass().getCanonicalName() + ") is a changeset and cannot be updated");
            }
            if (!((Private)changeset).isChangeset() || ((Private)changeset).status() != Status.MODIFIED) {
                throw new IllegalArgumentException("entity " + this.bean.id() + "(" + this.getClass().getCanonicalName() + ") cannot be updated with a " + (((Private)changeset).status() == null ? "NEW" : ((Private)changeset).status()) + " object");
            }
            if (!this.id().equals(((Private)changeset).id())) {
                throw new IllegalArgumentException("changeset " + ((Private)changeset).id() + "(" + changeset.getClass().getCanonicalName() + ") is not a changeset for entity " + this.id());
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.bean == null ? 0 : this.bean.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Private)) {
                return false;
            }
            Private other = (Private)obj;
            return !(this.bean == null ? other.bean != null : !this.bean.equals(other.bean));
        }
    }

    public static interface Bean
    extends Identified {
        public Status status();
    }
}

