/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.utils;

import javax.enterprise.event.Observes;
import org.cotrix.common.events.ApplicationLifecycleEvents;
import org.cotrix.common.events.Current;
import org.cotrix.domain.attributes.Attribute;
import org.cotrix.domain.attributes.AttributeDefinition;
import org.cotrix.domain.codelist.Code;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.domain.dsl.Data;
import org.cotrix.domain.dsl.Users;
import org.cotrix.domain.dsl.grammar.AttributeGrammar;
import org.cotrix.domain.links.AttributeLink;
import org.cotrix.domain.links.LinkDefinition;
import org.cotrix.domain.links.LinkOfLink;
import org.cotrix.domain.links.LinkValueType;
import org.cotrix.domain.trait.Definition;
import org.cotrix.domain.user.User;
import org.cotrix.domain.utils.AttributeTemplate;
import org.jboss.weld.context.RequestContext;

public class DomainUtils {
    private static User currentUser;
    private static RequestContext requestContext;

    static void setUser(@Observes ApplicationLifecycleEvents.Startup startup, @Current User user, @Current RequestContext context) {
        currentUser = user;
        requestContext = context;
    }

    public static User currentUser() {
        return DomainUtils.currentUserOr(Users.cotrix);
    }

    public static User currentUserOr(User fallback) {
        return requestContext.isActive() ? currentUser : fallback;
    }

    public static Attribute.Bean beanOf(Attribute a) {
        return (Attribute.Bean)Data.reveal(a).bean();
    }

    public static AttributeDefinition.Bean beanOf(AttributeDefinition def) {
        return (AttributeDefinition.Bean)Data.reveal(def).bean();
    }

    public static LinkDefinition.Bean beanOf(LinkDefinition def) {
        return (LinkDefinition.Bean)Data.reveal(def).bean();
    }

    public static Code.Bean beanOf(Code c) {
        return (Code.Bean)Data.reveal(c).bean();
    }

    public static Attribute.Bean beanOf(AttributeGrammar.ThirdClause clause) {
        return DomainUtils.beanOf((Attribute)clause.build());
    }

    public static String signatureOf(Codelist list) {
        return String.format("%s  (%s v.%s)", list.id(), list.qname(), list.version());
    }

    public static String languageOf(Definition def) {
        if (def instanceof LinkDefinition) {
            LinkDefinition ldef = (LinkDefinition)LinkDefinition.class.cast(def);
            AttributeTemplate template = DomainUtils.templateFrom(ldef.valueType());
            return template == null || template.language() == null ? "en" : template.language();
        }
        if (def instanceof AttributeDefinition) {
            return ((AttributeDefinition)AttributeDefinition.class.cast(def)).language();
        }
        return null;
    }

    public static AttributeTemplate templateFrom(LinkValueType type) {
        if (type instanceof AttributeLink) {
            return ((AttributeLink)AttributeLink.class.cast(type)).template();
        }
        if (type instanceof LinkOfLink) {
            return DomainUtils.templateFrom(((LinkOfLink)LinkOfLink.class.cast(type)).target().valueType());
        }
        return null;
    }
}

