/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.io.tabular.map;

import javax.xml.namespace.QName;
import org.cotrix.io.tabular.map.MappingMode;
import org.virtualrepository.tabular.Column;

public class ColumnDirectives {
    private final Column column;
    private QName name;
    private QName type;
    private String language;
    private boolean required = false;
    private MappingMode mode = MappingMode.LOG;

    public static ColumnDirectives column(String name) {
        return ColumnDirectives.column(new QName(name));
    }

    public static ColumnDirectives column(QName name) {
        return new ColumnDirectives(new Column(name));
    }

    public ColumnDirectives(Column column) {
        this.column = column;
    }

    public Column column() {
        return this.column;
    }

    public QName name() {
        return this.name == null ? this.column.name() : this.name;
    }

    public ColumnDirectives name(QName name) {
        this.name = name;
        return this;
    }

    public boolean required() {
        return this.required;
    }

    public void required(boolean required) {
        this.required = required;
    }

    public ColumnDirectives name(String name) {
        return this.name(new QName(name));
    }

    public ColumnDirectives type(String type) {
        return this.type(new QName(type));
    }

    public ColumnDirectives type(QName type) {
        this.type = type;
        return this;
    }

    public ColumnDirectives mode(MappingMode mode) {
        this.mode = mode;
        return this;
    }

    public MappingMode mode() {
        return this.mode;
    }

    public QName type() {
        return this.type;
    }

    public String language() {
        return this.language;
    }

    public ColumnDirectives language(String language) {
        this.language = language;
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ColumnDirectives [column=");
        builder.append(this.column);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", type=");
        builder.append(this.type);
        builder.append(", language=");
        builder.append(this.language);
        builder.append(", mode=");
        builder.append((Object)this.mode);
        builder.append("]");
        return builder.toString();
    }
}

