/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.io.impl;

import java.io.InputStream;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.cotrix.common.CommonUtils;
import org.cotrix.io.ParseService;
import org.cotrix.io.impl.ParseTask;
import org.cotrix.io.utils.Registry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class DefaultParseService
implements ParseService {
    private static Logger log = LoggerFactory.getLogger(ParseService.class);
    private final Registry<ParseTask<?, ?>> registry;

    @Inject
    public DefaultParseService(Iterable<ParseTask<?, ?>> tasks) {
        CommonUtils.notNull((String)"parse tasks", tasks);
        this.registry = new Registry(tasks);
        log.info("configured with tasks {}", this.registry.tasks());
    }

    @Override
    public <T> T parse(InputStream stream, ParseService.ParseDirectives<T> directives) {
        CommonUtils.notNull((String)"stream", (Object)stream);
        CommonUtils.notNull((String)"directives", directives);
        double time = System.currentTimeMillis();
        try {
            ParseTask<?, ?> task = this.registry.get(directives);
            Object result = task.parse(stream, directives);
            time = ((double)System.currentTimeMillis() - time) / 1000.0;
            log.info("parsed stream in {} secs.", (Object)time);
            return (T)result;
        }
        catch (Exception e) {
            throw new IllegalStateException("could not parse stream with directives " + directives + " (see cause) ", e);
        }
    }
}

