/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.lifecycle.impl.memory;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.cotrix.common.CommonUtils;
import org.cotrix.lifecycle.LifecycleFactory;
import org.cotrix.lifecycle.LifecycleRegistry;

@Singleton
public class MLifecycleRegistry
implements LifecycleRegistry {
    private final Map<String, LifecycleFactory> factories = new HashMap<String, LifecycleFactory>();

    @Inject
    public MLifecycleRegistry(List<? extends LifecycleFactory> factories) {
        CommonUtils.notNull((String)"lifecycle factories", factories);
        for (LifecycleFactory lifecycleFactory : factories) {
            this.factories.put(lifecycleFactory.name(), lifecycleFactory);
        }
    }

    @Override
    public LifecycleFactory get(String name) {
        CommonUtils.valid((String)"factory name", (String)name);
        return this.factories.get(name);
    }

    @Override
    public void add(LifecycleFactory factory) {
        CommonUtils.notNull((String)"lifecycle factory", (Object)factory);
        this.factories.put(factory.name(), factory);
    }
}

