/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.application.mail;

import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Alternative;
import javax.inject.Inject;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.cotrix.application.MailService;
import org.cotrix.application.mail.MailConfiguration;
import org.cotrix.common.Utils;
import org.cotrix.configuration.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alternative
@Priority(value=1000)
@ApplicationScoped
public class DefaultMailService
implements MailService {
    private static Logger log = LoggerFactory.getLogger(DefaultMailService.class);
    @Inject
    protected Provider<MailConfiguration> provider;

    @PostConstruct
    public void init() {
        if (!((MailConfiguration)this.provider.get()).isEnabled()) {
            log.info("mail service is disabled");
        }
    }

    public void sendMessage(Collection<String> recipients, String subject, String body) {
        Utils.valid((String)"recipients", recipients);
        Utils.valid((String)"subject", (String)subject);
        Utils.valid((String)"body", (String)body);
        final MailConfiguration config = (MailConfiguration)this.provider.get();
        if (!config.isEnabled()) {
            return;
        }
        log.trace("mailing {} about: {}", recipients, (Object)subject);
        Properties props = new Properties();
        props.put("mail.smtp.auth", (Object)config.isAuth());
        props.put("mail.smtp.starttls.enable", (Object)config.isStartTls());
        props.put("mail.smtp.host", config.host());
        props.put("mail.smtp.port", (Object)config.port());
        log.trace("mail service configfuration: {}", (Object)props);
        Authenticator auth = new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(config.username(), config.pwd());
            }
        };
        Session session = Session.getInstance((Properties)props, (Authenticator)auth);
        try {
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(config.senderEmail()));
            StringBuilder addressList = new StringBuilder();
            Iterator<String> recipientIterator = recipients.iterator();
            while (recipientIterator.hasNext()) {
                addressList.append(recipientIterator.next());
                if (!recipientIterator.hasNext()) continue;
                addressList.append(',');
            }
            message.setRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)addressList.toString()));
            message.setSubject(subject);
            message.setText(body);
            Transport.send((Message)message);
        }
        catch (Exception e) {
            log.error("cannot send email {} to {}", (Object)subject, recipients);
        }
    }
}

