/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.neo.domain;

import javax.xml.namespace.QName;
import org.cotrix.domain.attributes.Attribute;
import org.cotrix.domain.attributes.Definition;
import org.cotrix.domain.trait.Identified;
import org.cotrix.domain.trait.Named;
import org.cotrix.neo.domain.Constants;
import org.cotrix.neo.domain.NeoDefinition;
import org.cotrix.neo.domain.NeoIdentified;
import org.cotrix.neo.domain.utils.NeoStateFactory;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public class NeoAttribute
extends NeoIdentified
implements Attribute.State {
    public static final NeoStateFactory<Attribute.State> factory = new NeoStateFactory<Attribute.State>(){

        @Override
        public Attribute.State beanFrom(Node node) {
            return new NeoAttribute(node);
        }

        @Override
        public Node nodeFrom(Attribute.State state) {
            return new NeoAttribute(state).node();
        }
    };

    public NeoAttribute(Node node) {
        super(node);
    }

    public NeoAttribute(Attribute.State state) {
        super(Constants.NodeType.ATTRIBUTE, (Identified.State)state);
        this.definition(state.definition());
        this.value(state.value());
    }

    public Definition.State definition() {
        Relationship rel = this.node().getSingleRelationship((RelationshipType)Constants.Relations.INSTANCEOF, Direction.OUTGOING);
        if (rel == null) {
            throw new IllegalStateException(this.id() + " has an orphaned definition link");
        }
        return (Definition.State)NeoDefinition.factory.beanFrom(rel.getEndNode());
    }

    public void definition(Definition.State state) {
        Node node = null;
        if (state.isShared()) {
            node = this.softResolve((Named.State)state, Constants.NodeType.DEFINITION);
        }
        if (node == null) {
            node = NeoDefinition.factory.nodeFrom(state);
        }
        this.node().createRelationshipTo(node, (RelationshipType)Constants.Relations.INSTANCEOF);
    }

    public QName name() {
        return this.definition().name();
    }

    public void name(QName name) {
        this.definition().name(name);
    }

    public QName type() {
        return this.definition().type();
    }

    public void type(QName type) {
        this.definition().type(type);
    }

    public String value() {
        return (String)this.node().getProperty("val", null);
    }

    public void value(String value) {
        if (value == null) {
            this.node().removeProperty("val");
        } else {
            this.node().setProperty("val", (Object)value);
        }
    }

    public String description() {
        return (String)this.node().getProperty("desc", null);
    }

    public void description(String value) {
        if (value == null) {
            this.node().removeProperty("desc");
        } else {
            this.node().setProperty("desc", (Object)value);
        }
    }

    public String language() {
        return this.definition().language();
    }

    public void language(String language) {
        this.definition().language(language);
    }

    public Attribute.Private entity() {
        return new Attribute.Private((Attribute.State)this);
    }
}

