/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.neo.repository;

import java.util.Iterator;
import javax.inject.Inject;
import org.cotrix.common.CommonUtils;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.neo.domain.Constants;
import org.cotrix.neo.domain.NeoCodelist;
import org.cotrix.neo.domain.utils.NeoBeanFactory;
import org.cotrix.neo.domain.utils.NeoNodeIterator;
import org.cotrix.neo.repository.NeoCriterion;
import org.cotrix.neo.repository.NeoMultiQuery;
import org.cotrix.neo.repository.NeoQueryEngine;
import org.cotrix.repository.CodelistCoordinates;
import org.cotrix.repository.Criterion;
import org.cotrix.repository.Query;
import org.neo4j.cypher.javacompat.ExecutionResult;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;

public abstract class NeoQueries {
    public static final String $node = "N";
    public static final String $result = "RESULT";
    @Inject
    protected NeoQueryEngine engine;

    public Query.Private<Object, Integer> repositorySize(final Constants.NodeType type) {
        return new Query.Private<Object, Integer>(){

            public Integer execute() {
                String query = String.format("MATCH (%1$s:%2$s) RETURN COUNT(%1$s) as %3$s", NeoQueries.$node, type.name(), NeoQueries.$result);
                ExecutionResult result = NeoQueries.this.engine.execute(query);
                try (ResourceIterator it = result.columnAs(NeoQueries.$result);){
                    Integer n = ((Long)it.next()).intValue();
                    return n;
                }
            }
        };
    }

    protected NeoCriterion<?> reveal(Criterion<?> c) {
        return (NeoCriterion)CommonUtils.reveal(c, NeoCriterion.class);
    }

    public <T> Criterion<T> descending(final Criterion<T> c) {
        return new NeoCriterion<T>(){

            @Override
            protected String process(NeoMultiQuery<?, ?> query) {
                query.setDescending();
                return NeoQueries.this.reveal(c).process(query);
            }
        };
    }

    public <T> Criterion<T> all(final Criterion<T> c1, final Criterion<T> c2) {
        return new NeoCriterion<T>(){

            @Override
            protected String process(NeoMultiQuery<?, ?> query) {
                return String.format("%1$s,%2$s", NeoQueries.this.reveal(c1).process(query), NeoQueries.this.reveal(c2).process(query));
            }
        };
    }

    protected Iterator<CodelistCoordinates> coordinates(ResourceIterator<Node> it) {
        NeoBeanFactory<CodelistCoordinates> factory = new NeoBeanFactory<CodelistCoordinates>(){

            @Override
            public CodelistCoordinates beanFrom(Node node) {
                NeoCodelist list = new NeoCodelist(node);
                return CodelistCoordinates.coordsOf((Codelist.Bean)list);
            }
        };
        return new NeoNodeIterator<CodelistCoordinates>((Iterator<Node>)it, factory);
    }
}

