/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.neo.domain;

import org.cotrix.common.CommonUtils;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.domain.common.Range;
import org.cotrix.domain.dsl.Data;
import org.cotrix.domain.links.LinkDefinition;
import org.cotrix.domain.links.LinkOfLink;
import org.cotrix.domain.links.LinkValueType;
import org.cotrix.domain.links.NameLink;
import org.cotrix.domain.trait.Described;
import org.cotrix.domain.trait.Named;
import org.cotrix.domain.utils.DomainConstants;
import org.cotrix.domain.values.ValueFunction;
import org.cotrix.domain.values.ValueFunctions;
import org.cotrix.neo.domain.Constants;
import org.cotrix.neo.domain.NeoCodelist;
import org.cotrix.neo.domain.NeoDescribed;
import org.cotrix.neo.domain.utils.NeoStateFactory;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public class NeoLinkDefinition
extends NeoDescribed
implements LinkDefinition.Bean {
    public static final NeoStateFactory<LinkDefinition.Bean> factory = new NeoStateFactory<LinkDefinition.Bean>(){

        @Override
        public LinkDefinition.Bean beanFrom(Node node) {
            return new NeoLinkDefinition(node);
        }

        @Override
        public Node nodeFrom(LinkDefinition.Bean state) {
            return new NeoLinkDefinition(state).node();
        }
    };

    public NeoLinkDefinition(Node node) {
        super(node);
    }

    public NeoLinkDefinition(LinkDefinition.Bean state) {
        super(Constants.NodeType.LINKDEF, (Described.Bean)state);
        this.target(state.target());
        this.valueType(state.valueType());
        this.function(state.function());
        this.range(state.range());
    }

    public LinkDefinition.Private entity() {
        return new LinkDefinition.Private((LinkDefinition.Bean)this);
    }

    public Codelist.Bean target() {
        Relationship rel = this.node().getSingleRelationship((RelationshipType)Constants.Relations.LINK, Direction.OUTGOING);
        if (rel == null) {
            throw new IllegalStateException("orphaned codelist link " + this.qname() + " (" + this.id() + ")");
        }
        return (Codelist.Bean)NeoCodelist.factory.beanFrom(rel.getEndNode());
    }

    public void target(Codelist.Bean bean) {
        Node target = this.resolve((Named.Bean)bean, Constants.NodeType.CODELIST);
        if (target != null) {
            this.node().createRelationshipTo(target, (RelationshipType)Constants.Relations.LINK);
        }
    }

    public LinkValueType valueType() {
        if (this.node().hasProperty("type")) {
            return (LinkValueType)CommonUtils.binder().fromXML((String)this.node().getProperty("type"));
        }
        Relationship rel = this.node().getSingleRelationship((RelationshipType)Constants.Relations.LOL, Direction.OUTGOING);
        if (rel != null) {
            return new LinkOfLink((LinkDefinition)((LinkDefinition.Bean)factory.beanFrom(rel.getEndNode())).entity());
        }
        return NameLink.INSTANCE;
    }

    public void valueType(LinkValueType state) {
        if (state == NameLink.INSTANCE) {
            this.removeValueType();
            return;
        }
        if (state instanceof LinkOfLink) {
            LinkDefinition link = ((LinkOfLink)state).target();
            Node target = this.resolve((Named.Bean)Data.reveal((LinkDefinition)link).bean(), Constants.NodeType.CODELINK);
            if (target != null) {
                this.node().createRelationshipTo(target, (RelationshipType)Constants.Relations.LOL);
            }
            return;
        }
        this.node().setProperty("type", (Object)CommonUtils.binder().toXML((Object)state));
    }

    private void removeValueType() {
        Relationship rel;
        if (this.node().hasProperty("type")) {
            this.node().removeProperty("type");
        }
        if ((rel = this.node().getSingleRelationship((RelationshipType)Constants.Relations.LOL, Direction.OUTGOING)) != null) {
            rel.delete();
        }
    }

    public Range range() {
        return this.node().hasProperty("range") ? (Range)CommonUtils.binder().fromXML((String)this.node().getProperty("range")) : DomainConstants.defaultRange;
    }

    public void range(Range type) {
        if (type != DomainConstants.defaultRange) {
            this.node().setProperty("range", (Object)CommonUtils.binder().toXML((Object)type));
        }
    }

    public ValueFunction function() {
        return this.node().hasProperty("function") ? (ValueFunction)CommonUtils.binder().fromXML((String)this.node().getProperty("function")) : ValueFunctions.identity;
    }

    public void function(ValueFunction type) {
        if (type != ValueFunctions.identity) {
            this.node().setProperty("function", (Object)CommonUtils.binder().toXML((Object)type));
        }
    }
}

