/*
 * Decompiled with CFR 0.152.
 */
package org.acme;

import java.util.Arrays;
import java.util.Collection;
import javax.inject.Inject;
import javax.xml.namespace.QName;
import org.cotrix.action.Action;
import org.cotrix.action.Actions;
import org.cotrix.action.ResourceType;
import org.cotrix.common.Utils;
import org.cotrix.domain.codelist.Code;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.domain.common.Attribute;
import org.cotrix.domain.dsl.Codes;
import org.cotrix.domain.dsl.Roles;
import org.cotrix.domain.dsl.Users;
import org.cotrix.domain.dsl.grammar.AttributeGrammar;
import org.cotrix.domain.dsl.grammar.CodeGrammar;
import org.cotrix.domain.dsl.grammar.CodelistGrammar;
import org.cotrix.domain.user.Role;
import org.cotrix.domain.user.User;
import org.cotrix.repository.CodelistCoordinates;
import org.cotrix.repository.CodelistQueries;
import org.cotrix.repository.CodelistRepository;
import org.cotrix.repository.CodelistSummary;
import org.cotrix.repository.Criterion;
import org.cotrix.repository.Query;
import org.cotrix.test.ApplicationTest;
import org.junit.Assert;
import org.junit.Test;

public class CodelistRepositoryQueryTest
extends ApplicationTest {
    @Inject
    CodelistRepository repository;

    @Test
    public void allCodelists() {
        Codelist list = (Codelist)((CodelistGrammar.SecondClause)Codes.codelist().name("name")).build();
        Codelist list2 = (Codelist)((CodelistGrammar.SecondClause)Codes.codelist().name("name2")).build();
        this.repository.add((Object)list);
        this.repository.add((Object)list2);
        Iterable lists = (Iterable)this.repository.get((Query)CodelistQueries.allLists());
        Utils.assertEqualUnordered((Collection)Utils.collect((Iterable)lists), (Object[])new Object[]{list, list2});
    }

    @Test
    public void allCodelistsExcludingSome() {
        Codelist list1 = (Codelist)((CodelistGrammar.SecondClause)Codes.codelist().name("name1")).build();
        Codelist list2 = (Codelist)((CodelistGrammar.SecondClause)Codes.codelist().name("name2")).build();
        this.repository.add((Object)list1);
        this.repository.add((Object)list2);
        Iterable lists = (Iterable)this.repository.get((Query)CodelistQueries.allLists().excluding(new String[]{list1.id()}));
        Utils.assertEqualUnordered((Collection)Utils.collect((Iterable)lists), (Object[])new Object[]{list2});
    }

    @Test
    public void allCodelistForRootLikeUser() {
        Codelist list = (Codelist)((CodelistGrammar.SecondClause)Codes.codelist().name("1")).build();
        this.repository.add((Object)list);
        Action a = Actions.action((ResourceType)ResourceType.codelists, (String)"a", (String[])new String[0]);
        Role role = Roles.role((String)"r").can(new Action[]{a}).buildAsRoleFor(ResourceType.codelists);
        User u = Users.user().name("joe").fullName("joe").noMail().is(new Role[]{role}).build();
        Iterable lists = (Iterable)this.repository.get((Query)CodelistQueries.codelistsFor((User)u));
        Utils.assertEqualUnordered((Collection)Utils.collect((Iterable)lists), (Object[])new Object[]{CodelistCoordinates.coordsOf((Codelist)list)});
    }

    @Test
    public void allCodelistForUser() {
        Codelist list = (Codelist)((CodelistGrammar.SecondClause)Codes.codelist().name("1")).build();
        Codelist list2 = (Codelist)((CodelistGrammar.SecondClause)Codes.codelist().name("2")).build();
        this.repository.add((Object)list);
        this.repository.add((Object)list2);
        Action a = Actions.action((ResourceType)ResourceType.codelists, (String)"a", (String[])new String[0]);
        Role role = Roles.role((String)"r").can(new Action[]{a}).buildAsRoleFor(ResourceType.codelists);
        User u = Users.user().name("joe").fullName("joe").noMail().is(new Role[]{role.on(list2.id())}).build();
        Iterable lists = (Iterable)this.repository.get((Query)CodelistQueries.codelistsFor((User)u));
        Utils.assertEqualUnordered((Collection)Utils.collect((Iterable)lists), (Object[])new Object[]{CodelistCoordinates.coordsOf((Codelist)list2)});
    }

    @Test
    public void allCodes() {
        Code code1 = (Code)((CodeGrammar.OptionalClause)Codes.code().name("c1")).build();
        Code code2 = (Code)((CodeGrammar.OptionalClause)Codes.code().name("c2")).build();
        Code code3 = (Code)((CodeGrammar.OptionalClause)Codes.code().name("c3")).build();
        Codelist list = (Codelist)((CodelistGrammar.SecondClause)((CodelistGrammar.SecondClause)Codes.codelist().name("l")).with((Object[])new Code[]{code1, code2, code3})).build();
        this.repository.add((Object)list);
        Iterable codes = (Iterable)this.repository.get((Query)CodelistQueries.allCodesIn((String)list.id()));
        Utils.assertEqualOrdered((Collection)Utils.collect((Iterable)codes), (Object[])new Object[]{code1, code2, code3});
    }

    @Test
    public void codeRanges() {
        Code code1 = (Code)((CodeGrammar.OptionalClause)Codes.code().name("c1")).build();
        Code code2 = (Code)((CodeGrammar.OptionalClause)Codes.code().name("c2")).build();
        Code code3 = (Code)((CodeGrammar.OptionalClause)Codes.code().name("c3")).build();
        Codelist list = (Codelist)((CodelistGrammar.SecondClause)((CodelistGrammar.SecondClause)Codes.codelist().name("l")).with((Object[])new Code[]{code1, code2, code3})).build();
        this.repository.add((Object)list);
        Iterable inrange = (Iterable)this.repository.get((Query)CodelistQueries.allCodesIn((String)list.id()).from(2).to(3));
        Assert.assertEquals(Arrays.asList(code2, code3), (Object)Utils.collect((Iterable)inrange));
    }

    @Test
    public void listCoordinates() {
        Codelist list1 = (Codelist)((CodelistGrammar.SecondClause)Codes.codelist().name("l1")).version("1").build();
        Codelist list2 = (Codelist)((CodelistGrammar.SecondClause)Codes.codelist().name("l2")).version("2").build();
        this.repository.add((Object)list2);
        this.repository.add((Object)list1);
        Iterable results = (Iterable)this.repository.get((Query)CodelistQueries.allListCoordinates().sort(CodelistQueries.byCoordinateName()));
        Utils.assertEqualUnordered((Collection)Utils.collect((Iterable)results), (Object[])new Object[]{CodelistCoordinates.coords((String)list1.id(), (QName)Codes.q((String)"l1"), (String)"1"), CodelistCoordinates.coords((String)list2.id(), (QName)Codes.q((String)"l2"), (String)"2")});
    }

    @Test
    public void listbyName() {
        Codelist list1 = (Codelist)((CodelistGrammar.SecondClause)Codes.codelist().name("l1")).build();
        Codelist list2 = (Codelist)((CodelistGrammar.SecondClause)Codes.codelist().name("l2")).build();
        this.repository.add((Object)list2);
        this.repository.add((Object)list1);
        Iterable results = (Iterable)this.repository.get((Query)CodelistQueries.allLists().sort(CodelistQueries.byCodelistName()));
        Assert.assertEquals(Arrays.asList(list1, list2), (Object)Utils.collect((Iterable)results));
    }

    @Test
    public void listbyNameAndVersion() {
        Codelist list1 = (Codelist)((CodelistGrammar.SecondClause)Codes.codelist().name("l2")).version("1").build();
        Codelist list2 = (Codelist)((CodelistGrammar.SecondClause)Codes.codelist().name("l2")).version("3").build();
        this.repository.add((Object)list2);
        this.repository.add((Object)list1);
        Iterable results = (Iterable)this.repository.get((Query)CodelistQueries.allLists().sort(CodelistQueries.all((Criterion)CodelistQueries.byCodelistName(), (Criterion)CodelistQueries.byVersion())));
        Assert.assertEquals(Arrays.asList(list1, list2), (Object)Utils.collect((Iterable)results));
    }

    @Test
    public void listbyCodeName() {
        Code c1 = (Code)((CodeGrammar.OptionalClause)Codes.code().name("c1")).build();
        Code c2 = (Code)((CodeGrammar.OptionalClause)Codes.code().name("c2")).build();
        Codelist list = (Codelist)((CodelistGrammar.SecondClause)((CodelistGrammar.SecondClause)Codes.codelist().name("l1")).with((Object[])new Code[]{c2, c1})).build();
        this.repository.add((Object)list);
        Iterable results = (Iterable)this.repository.get((Query)CodelistQueries.allCodesIn((String)list.id()).sort(CodelistQueries.byCodeName()));
        Assert.assertEquals(Arrays.asList(c1, c2), (Object)Utils.collect((Iterable)results));
    }

    @Test
    public void listbyCodeNameDescending() {
        Code c1 = (Code)((CodeGrammar.OptionalClause)Codes.code().name("c1")).build();
        Code c2 = (Code)((CodeGrammar.OptionalClause)Codes.code().name("c2")).build();
        Code c3 = (Code)((CodeGrammar.OptionalClause)Codes.code().name("c3")).build();
        Codelist list = (Codelist)((CodelistGrammar.SecondClause)((CodelistGrammar.SecondClause)Codes.codelist().name("l1")).with((Object[])new Code[]{c2, c3, c1})).build();
        this.repository.add((Object)list);
        Iterable results = (Iterable)this.repository.get((Query)CodelistQueries.allCodesIn((String)list.id()).sort(CodelistQueries.descending((Criterion)CodelistQueries.byCodeName())));
        Assert.assertEquals(Arrays.asList(c3, c2, c1), (Object)Utils.collect((Iterable)results));
    }

    @Test
    public void listCodesSortedByAttribute() {
        Attribute a1 = (Attribute)((AttributeGrammar.OptionalClause)Codes.attribute().name("a")).value("1").build();
        Attribute a12 = (Attribute)((AttributeGrammar.OptionalClause)Codes.attribute().name("a")).value("5").build();
        Attribute b = (Attribute)((AttributeGrammar.OptionalClause)Codes.attribute().name("b")).value("3").build();
        Code c1 = (Code)((CodeGrammar.OptionalClause)((CodeGrammar.OptionalClause)Codes.code().name("c1")).attributes(new Attribute[]{a1, a12, b})).build();
        Attribute a2 = (Attribute)((AttributeGrammar.OptionalClause)Codes.attribute().name("a")).value("2").in("en").build();
        Attribute a22 = (Attribute)((AttributeGrammar.OptionalClause)Codes.attribute().name("a")).value("3").build();
        Attribute b1 = (Attribute)((AttributeGrammar.OptionalClause)Codes.attribute().name("b")).value("3").build();
        Code c2 = (Code)((CodeGrammar.OptionalClause)((CodeGrammar.OptionalClause)Codes.code().name("c2")).attributes(new Attribute[]{a2, a22, b1})).build();
        Attribute a3 = (Attribute)((AttributeGrammar.OptionalClause)Codes.attribute().name("a")).value("0").in("en").build();
        Attribute b2 = (Attribute)((AttributeGrammar.OptionalClause)Codes.attribute().name("b")).value("4").build();
        Code c3 = (Code)((CodeGrammar.OptionalClause)((CodeGrammar.OptionalClause)Codes.code().name("c3")).attributes(new Attribute[]{a3, b2})).build();
        Codelist list = (Codelist)((CodelistGrammar.SecondClause)((CodelistGrammar.SecondClause)Codes.codelist().name("l1")).with((Object[])new Code[]{c1, c2, c3})).build();
        this.repository.add((Object)list);
        Attribute template = (Attribute)((AttributeGrammar.OptionalClause)Codes.attribute().name("a")).value("ignore").build();
        Iterable results = (Iterable)this.repository.get((Query)CodelistQueries.allCodesIn((String)list.id()).sort(CodelistQueries.byAttribute((Attribute)template, (int)1)));
        Assert.assertEquals(Arrays.asList(c3, c1, c2), (Object)Utils.collect((Iterable)results));
        results = (Iterable)this.repository.get((Query)CodelistQueries.allCodesIn((String)list.id()).sort(CodelistQueries.descending((Criterion)CodelistQueries.byAttribute((Attribute)template, (int)1))));
        Assert.assertEquals(Arrays.asList(c2, c1, c3), (Object)Utils.collect((Iterable)results));
        results = (Iterable)this.repository.get((Query)CodelistQueries.allCodesIn((String)list.id()).sort(CodelistQueries.byAttribute((Attribute)template, (int)2)));
        Assert.assertEquals(Arrays.asList(c2, c1, c3), (Object)Utils.collect((Iterable)results));
        template = (Attribute)((AttributeGrammar.OptionalClause)Codes.attribute().name("a")).value("ignore").in("en").build();
        results = (Iterable)this.repository.get((Query)CodelistQueries.allCodesIn((String)list.id()).sort(CodelistQueries.byAttribute((Attribute)template, (int)1)));
        Assert.assertEquals(Arrays.asList(c3, c2, c1), (Object)Utils.collect((Iterable)results));
    }

    @Test
    public void getSummary() {
        Attribute a1 = (Attribute)((AttributeGrammar.OptionalClause)Codes.attribute().name("name1")).value("v1").ofType("t1").in("l1").build();
        Attribute a2 = (Attribute)((AttributeGrammar.OptionalClause)Codes.attribute().name("name2")).value("v2").ofType("t2").build();
        Attribute a3 = (Attribute)((AttributeGrammar.OptionalClause)Codes.attribute().name("name1")).value("v3").ofType("t2").in("l1").build();
        Attribute a4 = (Attribute)((AttributeGrammar.OptionalClause)Codes.attribute().name("name1")).value("v1").ofType("t1").in("l2").build();
        Attribute a5 = (Attribute)((AttributeGrammar.OptionalClause)Codes.attribute().name("name2")).value("v2").ofType("t2").build();
        Attribute aa1 = (Attribute)((AttributeGrammar.OptionalClause)Codes.attribute().name("name1")).value("v1").ofType("t3").in("l3").build();
        Attribute aa2 = (Attribute)((AttributeGrammar.OptionalClause)Codes.attribute().name("name2")).value("v2").ofType("t2").build();
        Attribute aa3 = (Attribute)((AttributeGrammar.OptionalClause)Codes.attribute().name("name3")).value("v3").ofType("t3").in("l2").build();
        Attribute aa4 = (Attribute)((AttributeGrammar.OptionalClause)Codes.attribute().name("name1")).value("v4").ofType("t1").in("l3").build();
        Code c1 = (Code)((CodeGrammar.OptionalClause)((CodeGrammar.OptionalClause)Codes.code().name("c1")).attributes(new Attribute[]{a1, a2, a3})).build();
        Code c2 = (Code)((CodeGrammar.OptionalClause)((CodeGrammar.OptionalClause)Codes.code().name("name1")).attributes(new Attribute[]{a4, a5})).build();
        Codelist list = (Codelist)((CodelistGrammar.SecondClause)((CodelistGrammar.SecondClause)((CodelistGrammar.SecondClause)Codes.codelist().name("n")).with((Object[])new Code[]{c1, c2})).attributes(new Attribute[]{aa1, aa2, aa3, aa4})).build();
        this.repository.add((Object)list);
        CodelistSummary summary = (CodelistSummary)this.repository.get(CodelistQueries.summary((String)list.id()));
        Assert.assertEquals((Object)Codes.q((String)"n"), (Object)summary.name());
        Assert.assertEquals((long)2L, (long)summary.size());
        Utils.assertEqualUnordered((Collection)summary.allNames(), (Object[])new Object[]{Codes.q((String)"name1"), Codes.q((String)"name2"), Codes.q((String)"name3")});
        Utils.assertEqualUnordered((Collection)summary.allTypes(), (Object[])new Object[]{Codes.q((String)"t1"), Codes.q((String)"t2"), Codes.q((String)"t3")});
        Utils.assertEqualUnordered((Collection)summary.allLanguages(), (Object[])new Object[]{"l1", "l2", "l3"});
        Utils.assertEqualUnordered((Collection)summary.allTypesFor(Codes.q((String)"name1")), (Object[])new Object[]{Codes.q((String)"t1"), Codes.q((String)"t2"), Codes.q((String)"t3")});
        Utils.assertEqualUnordered((Collection)summary.allLanguagesFor(Codes.q((String)"name1"), Codes.q((String)"t1")), (Object[])new Object[]{"l1", "l2", "l3"});
        Utils.assertEqualUnordered((Collection)summary.allTypesFor(Codes.q((String)"foo")), (Object[])new Object[0]);
        Utils.assertEqualUnordered((Collection)summary.allLanguagesFor(Codes.q((String)"foo"), Codes.q((String)"boo")), (Object[])new Object[0]);
        Utils.assertEqualUnordered((Collection)summary.codelistNames(), (Object[])new Object[]{Codes.q((String)"name1"), Codes.q((String)"name2"), Codes.q((String)"name3")});
        Utils.assertEqualUnordered((Collection)summary.codelistTypesFor(Codes.q((String)"name1")), (Object[])new Object[]{Codes.q((String)"t1"), Codes.q((String)"t3")});
        Utils.assertEqualUnordered((Collection)summary.codelistLanguagesFor(Codes.q((String)"name1"), Codes.q((String)"t1")), (Object[])new Object[]{"l3"});
        Utils.assertEqualUnordered((Collection)summary.codeNames(), (Object[])new Object[]{Codes.q((String)"name1"), Codes.q((String)"name2")});
        Utils.assertEqualUnordered((Collection)summary.codeTypesFor(Codes.q((String)"name1")), (Object[])new Object[]{Codes.q((String)"t1"), Codes.q((String)"t2")});
        Utils.assertEqualUnordered((Collection)summary.codeLanguagesFor(Codes.q((String)"name1"), Codes.q((String)"t1")), (Object[])new Object[]{"l1", "l2"});
    }
}

