/*
 * Decompiled with CFR 0.152.
 */
package org.acme.codelists;

import org.acme.DomainTest;
import org.acme.codelists.Fixture;
import org.cotrix.domain.common.Attribute;
import org.cotrix.domain.dsl.Codes;
import org.cotrix.domain.dsl.grammar.AttributeGrammar;
import org.cotrix.domain.memory.AttributeMS;
import org.cotrix.domain.trait.Status;
import org.cotrix.domain.utils.Constants;
import org.junit.Assert;
import org.junit.Test;

public class AttributeTest
extends DomainTest {
    @Test
    public void attributesCanBeFluentlyConstructed() {
        Attribute a = (Attribute)((AttributeGrammar.ValueClause)Codes.attribute().name(Fixture.name)).value(Fixture.value).build();
        Assert.assertEquals((Object)Fixture.name, (Object)a.name());
        Assert.assertEquals((Object)Fixture.value, (Object)a.value());
        Assert.assertEquals((Object)Constants.DEFAULT_TYPE, (Object)a.type());
        a = (Attribute)((AttributeGrammar.ValueClause)Codes.attribute().name(Fixture.name)).value(Fixture.value).ofType(Fixture.type).build();
        Assert.assertEquals((Object)Fixture.type, (Object)a.type());
        a = (Attribute)((AttributeGrammar.ValueClause)Codes.attribute().name(Fixture.name)).value(Fixture.value).ofType(Fixture.name).in(Fixture.language).build();
        Assert.assertEquals((Object)Fixture.language, (Object)a.language());
        ((AttributeGrammar.ValueClause)Codes.attribute().name(Fixture.name)).value(Fixture.value).in(Fixture.language).build();
    }

    @Test
    public void changesetsCanBeFluentlyConstructed() {
        Attribute a = (Attribute)((AttributeGrammar.ValueClause)Codes.attribute().name(Fixture.name)).build();
        a = (Attribute)((AttributeGrammar.ValueClause)Codes.attribute().name(Fixture.name)).value(Fixture.value).build();
        a = (Attribute)((AttributeGrammar.ValueClause)Codes.attribute().name(Fixture.name)).value(Fixture.value).ofType("type").build();
        a = (Attribute)((AttributeGrammar.ValueClause)Codes.attribute().name(Fixture.name)).value(Fixture.value).ofType("type").in("en").build();
        a = (Attribute)((AttributeGrammar.ValueClause)Codes.attribute().name(Fixture.name)).value(Fixture.value).in("en").build();
        Assert.assertFalse((boolean)Codes.reveal((Attribute)a).isChangeset());
        Assert.assertNull((Object)Codes.reveal((Attribute)a).status());
        a = (Attribute)((AttributeGrammar.ValueClause)Codes.modifyAttribute((String)"1").name(Fixture.name)).build();
        a = (Attribute)((AttributeGrammar.ValueClause)Codes.modifyAttribute((String)"1").name(Fixture.name)).value(Fixture.value).build();
        a = (Attribute)Codes.modifyAttribute((String)"1").ofType("type").build();
        a = (Attribute)Codes.modifyAttribute((String)"1").ofType("type").in("en").build();
        a = (Attribute)Codes.modifyAttribute((String)"1").in("en").build();
        Assert.assertTrue((boolean)Codes.reveal((Attribute)a).isChangeset());
        Assert.assertEquals((Object)Status.MODIFIED, (Object)Codes.reveal((Attribute)a).status());
        a = Codes.deleteAttribute((String)"1");
        Assert.assertTrue((boolean)Codes.reveal((Attribute)a).isChangeset());
        Assert.assertEquals((Object)Status.DELETED, (Object)Codes.reveal((Attribute)a).status());
    }

    @Test
    public void cloned() {
        Attribute a = (Attribute)this.like(((AttributeGrammar.ValueClause)Codes.attribute().name(Fixture.name)).value(Fixture.value).ofType(Fixture.type).in(Fixture.language).build());
        Attribute.State state = (Attribute.State)Codes.reveal((Attribute)a).state();
        AttributeMS clone = new AttributeMS(state);
        Assert.assertEquals((Object)state, (Object)clone);
    }

    @Test
    public void emptyChangeset() {
        Attribute a = (Attribute)this.like(((AttributeGrammar.ValueClause)Codes.attribute().name(Fixture.name)).value(Fixture.value).ofType(Fixture.type).in(Fixture.language).build());
        Attribute changeset = (Attribute)Codes.modifyAttribute((String)a.id()).build();
        Codes.reveal((Attribute)a).update(Codes.reveal((Attribute)changeset));
        Assert.assertEquals((Object)Fixture.name, (Object)a.name());
        Assert.assertEquals((Object)Fixture.value, (Object)a.value());
        Assert.assertEquals((Object)Fixture.type, (Object)a.type());
        Assert.assertEquals((Object)Fixture.language, (Object)a.language());
    }

    @Test
    public void changesAttributes() {
        Attribute a = (Attribute)this.like(((AttributeGrammar.ValueClause)Codes.attribute().name(Fixture.name)).value(Fixture.value).ofType(Fixture.type).in(Fixture.language).build());
        Attribute changeset = (Attribute)((AttributeGrammar.ValueClause)Codes.modifyAttribute((String)a.id()).name(Fixture.name2)).value(Fixture.value2).ofType(Fixture.type2).in(Fixture.language2).build();
        Codes.reveal((Attribute)a).update(Codes.reveal((Attribute)changeset));
        Assert.assertEquals((Object)Fixture.name2, (Object)a.name());
        Assert.assertEquals((Object)Fixture.value2, (Object)a.value());
        Assert.assertEquals((Object)Fixture.type2, (Object)a.type());
        Assert.assertEquals((Object)Fixture.language2, (Object)a.language());
    }

    @Test
    public void cannotErasetNameOfAttributes() {
        Attribute a = (Attribute)this.like(((AttributeGrammar.ValueClause)Codes.attribute().name(Fixture.name)).build());
        Attribute changeset = (Attribute)((AttributeGrammar.ValueClause)Codes.modifyAttribute((String)a.id()).name(Constants.NULL_QNAME)).build();
        try {
            Codes.reveal((Attribute)a).update(Codes.reveal((Attribute)changeset));
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void erasesValue() {
        Attribute a = (Attribute)this.like(((AttributeGrammar.ValueClause)Codes.attribute().name(Fixture.name)).value(Fixture.value).ofType(Fixture.type).in(Fixture.language).build());
        Attribute changeset = (Attribute)Codes.modifyAttribute((String)a.id()).value("__ignore__").build();
        Codes.reveal((Attribute)a).update(Codes.reveal((Attribute)changeset));
        Assert.assertNull((Object)a.value());
        Assert.assertEquals((Object)Fixture.type, (Object)a.type());
        Assert.assertEquals((Object)Fixture.language, (Object)a.language());
    }

    @Test
    public void erasesType() {
        Attribute a = (Attribute)this.like(((AttributeGrammar.ValueClause)Codes.attribute().name(Fixture.name)).value(Fixture.value).ofType(Fixture.type).in(Fixture.language).build());
        Attribute changeset = (Attribute)Codes.modifyAttribute((String)a.id()).ofType(Constants.NULL_QNAME).build();
        Codes.reveal((Attribute)a).update(Codes.reveal((Attribute)changeset));
        Assert.assertNull((Object)a.type());
        Assert.assertEquals((Object)Fixture.name, (Object)a.name());
        Assert.assertEquals((Object)Fixture.language, (Object)a.language());
    }

    @Test
    public void erasesLanguage() {
        Attribute a = (Attribute)this.like(((AttributeGrammar.ValueClause)Codes.attribute().name(Fixture.name)).value(Fixture.value).ofType(Fixture.type).in(Fixture.language).build());
        Attribute changeset = (Attribute)Codes.modifyAttribute((String)a.id()).in("__ignore__").build();
        Codes.reveal((Attribute)a).update(Codes.reveal((Attribute)changeset));
        Assert.assertNull((Object)a.language());
        Assert.assertEquals((Object)Fixture.name, (Object)a.name());
        Assert.assertEquals((Object)Fixture.type, (Object)a.type());
    }
}

