/*
 * Decompiled with CFR 0.152.
 */
package org.acme.codelists;

import java.util.Arrays;
import java.util.Iterator;
import org.acme.DomainTest;
import org.acme.codelists.Fixture;
import org.cotrix.domain.attributes.Attribute;
import org.cotrix.domain.common.Container;
import org.cotrix.domain.common.Containers;
import org.cotrix.domain.dsl.Data;
import org.cotrix.domain.dsl.grammar.AttributeGrammar;
import org.cotrix.domain.trait.Named;
import org.junit.Assert;
import org.junit.Test;

public class ContainerTest
extends DomainTest {
    @Test
    public void beansMustBeValid() {
        try {
            new Container.Private((Container.Bean)null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void beansArePreserved() {
        Attribute a1 = (Attribute)((AttributeGrammar.FourthClause)Data.attribute().name(Fixture.name)).build();
        Attribute a2 = (Attribute)((AttributeGrammar.FourthClause)Data.attribute().name(Fixture.name2)).build();
        Container.Bean<Attribute.Bean> beans = this.likes(a1, a2);
        Containers.Attributes c = new Containers.Attributes(beans);
        Assert.assertEquals((long)2L, (long)c.size());
    }

    @Test
    public void beansAreWrapped() {
        Attribute a1 = (Attribute)((AttributeGrammar.FourthClause)Data.attribute().name(Fixture.name)).build();
        Attribute a2 = (Attribute)((AttributeGrammar.FourthClause)Data.attribute().name(Fixture.name2)).build();
        Containers.Attributes c = new Containers.Attributes(this.likes(a1, a2));
        Assert.assertTrue((boolean)c.contains((Named)a1));
        Assert.assertTrue((boolean)c.contains((Named)a2));
        Iterator it = c.iterator();
        Assert.assertEquals((Object)a1, it.next());
        Assert.assertEquals((Object)a2, it.next());
    }

    @Test
    public void namedEntitiesAreHandled() {
        Attribute a1 = (Attribute)((AttributeGrammar.FourthClause)Data.attribute().name("a")).build();
        Attribute a2 = (Attribute)((AttributeGrammar.FourthClause)Data.attribute().name("b")).build();
        Attribute a3 = (Attribute)((AttributeGrammar.FourthClause)Data.attribute().name("b")).build();
        Containers.Attributes c = new Containers.Attributes(this.likes(a1, a2, a3));
        Assert.assertTrue((boolean)c.contains((Named)a1));
        Assert.assertFalse((boolean)c.contains(Data.q((String)"c")));
        Assert.assertEquals(Arrays.asList(a1), (Object)c.get((Named)a1));
        Assert.assertEquals((Object)a1, (Object)c.getFirst((Named)a1));
        Assert.assertEquals(Arrays.asList(a2, a3), (Object)c.get((Named)a3));
        try {
            c.getFirst((Named)a3);
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
    }

    @Test
    public void entitiesCanBeLookedup() {
        Attribute a = (Attribute)((AttributeGrammar.FourthClause)Data.attribute().name(Fixture.name)).build();
        Containers.Attributes c = new Containers.Attributes(this.likes(a));
        Assert.assertTrue((boolean)c.contains((Named)a));
        Assert.assertEquals((Object)a, (Object)c.lookup(a.id()));
        Assert.assertNull((Object)c.lookup("bad"));
    }

    @Test
    public void entitiesCanBeAdded() {
        Containers.Attributes c = new Containers.Attributes();
        Attribute a = (Attribute)((AttributeGrammar.FourthClause)Data.attribute().name(Fixture.name)).build();
        Containers.Attributes changeset = new Containers.Attributes(this.likes(a));
        c.update((Container.Private)changeset);
        Assert.assertEquals((long)1L, (long)c.size());
        Assert.assertTrue((boolean)c.contains((Named)a));
    }

    @Test
    public void entitiesCanBeRemoved() {
        Attribute a = (Attribute)((AttributeGrammar.FourthClause)Data.attribute().name(Fixture.name)).build();
        Containers.Attributes c = new Containers.Attributes(this.likes(a));
        Attribute deleted = Data.deleteAttribute((String)a.id());
        Containers.Attributes changeset = new Containers.Attributes(new Attribute.Private[]{Data.reveal((Attribute)deleted)});
        c.update((Container.Private)changeset);
        Assert.assertEquals((long)0L, (long)c.size());
        Assert.assertFalse((boolean)c.contains((Named)a));
    }

    @Test
    public void entitiesCanBeModified() {
        Attribute a = (Attribute)((AttributeGrammar.FourthClause)Data.attribute().name(Fixture.name)).build();
        Container.Bean<Attribute.Bean> sc = this.likes(a);
        Containers.Attributes c = new Containers.Attributes(sc);
        Attribute modified = (Attribute)((AttributeGrammar.FourthClause)Data.modifyAttribute((String)a.id()).name(Fixture.name2)).build();
        Containers.Attributes changeset = new Containers.Attributes(new Attribute.Private[]{Data.reveal((Attribute)modified)});
        c.update((Container.Private)changeset);
        Assert.assertEquals((long)1L, (long)c.size());
        Assert.assertTrue((boolean)sc.contains(modified.qname()));
    }
}

