package org.cotrix.web.codelistmanager.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;

public interface ManagerServiceAsync
{

    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.cotrix.web.codelistmanager.client.ManagerService
     */
    void getCodelistCodes( java.lang.String codelistId, com.google.gwt.view.client.Range range, org.cotrix.web.codelistmanager.shared.CodelistEditorSortInfo sortInfo, AsyncCallback<org.cotrix.web.share.shared.DataWindow<org.cotrix.web.share.shared.codelist.UICode>> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.cotrix.web.codelistmanager.client.ManagerService
     */
    void getAttributesGroups( java.lang.String codelistId, AsyncCallback<java.util.Set<org.cotrix.web.codelistmanager.shared.Group>> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.cotrix.web.codelistmanager.client.ManagerService
     */
    void getCodelistsGrouped( AsyncCallback<org.cotrix.web.share.shared.DataWindow<org.cotrix.web.codelistmanager.shared.CodelistGroup>> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.cotrix.web.codelistmanager.client.ManagerService
     */
    void getMetadata( java.lang.String codelistId, AsyncCallback<org.cotrix.web.share.shared.codelist.UICodelistMetadata> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.cotrix.web.codelistmanager.client.ManagerService
     */
    void createNewCodelistVersion( java.lang.String codelistId, java.lang.String newVersion, AsyncCallback<org.cotrix.web.codelistmanager.shared.CodelistGroup> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.cotrix.web.codelistmanager.client.ManagerService
     */
    void removeCodelist( java.lang.String codelistId, AsyncCallback<Void> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.cotrix.web.codelistmanager.client.ManagerService
     */
    void getCodelistState( java.lang.String codelistId, AsyncCallback<org.cotrix.web.share.shared.feature.ResponseWrapper<java.lang.String>> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.cotrix.web.codelistmanager.client.ManagerService
     */
    void lock( java.lang.String codelistId, AsyncCallback<org.cotrix.web.share.shared.feature.FeatureCarrier.Void> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.cotrix.web.codelistmanager.client.ManagerService
     */
    void unlock( java.lang.String codelistId, AsyncCallback<org.cotrix.web.share.shared.feature.FeatureCarrier.Void> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.cotrix.web.codelistmanager.client.ManagerService
     */
    void seal( java.lang.String codelistId, AsyncCallback<org.cotrix.web.share.shared.feature.FeatureCarrier.Void> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.cotrix.web.codelistmanager.client.ManagerService
     */
    void modify( java.lang.String codelistId, org.cotrix.web.codelistmanager.shared.modify.ModifyCommand command, AsyncCallback<org.cotrix.web.codelistmanager.shared.modify.ModifyCommandResult> callback );


    /**
     * Utility class to get the RPC Async interface from client-side code
     */
    public static final class Util 
    { 
        private static ManagerServiceAsync instance;

        public static final ManagerServiceAsync getInstance()
        {
            if ( instance == null )
            {
                instance = (ManagerServiceAsync) GWT.create( ManagerService.class );
            }
            return instance;
        }

        private Util()
        {
            // Utility class should not be instanciated
        }
    }
}
