package org.cotrix.web.ingest.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;

public interface IngestServiceAsync
{

    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.cotrix.web.ingest.client.IngestService
     */
    void getAssets( com.google.gwt.view.client.Range range, org.cotrix.web.common.shared.ColumnSortInfo columnSortInfo, boolean forceRefresh, AsyncCallback<org.cotrix.web.common.shared.DataWindow<org.cotrix.web.ingest.shared.AssetInfo>> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.cotrix.web.ingest.client.IngestService
     */
    void getAssetDetails( java.lang.String assetId, AsyncCallback<org.cotrix.web.ingest.shared.AssetDetails> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.cotrix.web.ingest.client.IngestService
     */
    void getRepositoryDetails( org.cotrix.web.common.shared.codelist.UIQName repositoryId, AsyncCallback<org.cotrix.web.common.shared.codelist.RepositoryDetails> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.cotrix.web.ingest.client.IngestService
     */
    void setAsset( java.lang.String assetId, AsyncCallback<Void> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.cotrix.web.ingest.client.IngestService
     */
    void startUpload( AsyncCallback<Void> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.cotrix.web.ingest.client.IngestService
     */
    void getUploadProgress( AsyncCallback<org.cotrix.web.ingest.shared.FileUploadProgress> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.cotrix.web.ingest.client.IngestService
     */
    void getCsvPreviewData( org.cotrix.web.common.shared.CsvConfiguration configuration, AsyncCallback<org.cotrix.web.ingest.shared.PreviewData> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.cotrix.web.ingest.client.IngestService
     */
    void getCodeListType( AsyncCallback<org.cotrix.web.ingest.shared.CodeListType> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.cotrix.web.ingest.client.IngestService
     */
    void getMetadata( AsyncCallback<org.cotrix.web.ingest.shared.ImportMetadata> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.cotrix.web.ingest.client.IngestService
     */
    void getCsvParserConfiguration( AsyncCallback<org.cotrix.web.common.shared.CsvConfiguration> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.cotrix.web.ingest.client.IngestService
     */
    void getMappings( AsyncCallback<java.util.List<org.cotrix.web.ingest.shared.AttributeMapping>> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.cotrix.web.ingest.client.IngestService
     */
    void startImport( org.cotrix.web.common.shared.CsvConfiguration csvConfiguration, org.cotrix.web.ingest.shared.ImportMetadata metadata, java.util.List<org.cotrix.web.ingest.shared.AttributeMapping> mappings, org.cotrix.web.ingest.shared.MappingMode mappingMode, AsyncCallback<Void> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.cotrix.web.ingest.client.IngestService
     */
    void getImportProgress( AsyncCallback<org.cotrix.web.common.shared.Progress> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.cotrix.web.ingest.client.IngestService
     */
    void getReportLogs( com.google.gwt.view.client.Range range, AsyncCallback<org.cotrix.web.common.shared.DataWindow<org.cotrix.web.common.shared.ReportLog>> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.cotrix.web.ingest.client.IngestService
     */
    void getCsvPreviewHeaders( org.cotrix.web.common.shared.CsvConfiguration configuration, AsyncCallback<org.cotrix.web.ingest.shared.CsvPreviewHeaders> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.cotrix.web.ingest.client.IngestService
     */
    void getCsvPreviewData( com.google.gwt.view.client.Range range, AsyncCallback<org.cotrix.web.common.shared.DataWindow<java.util.List<java.lang.String>>> callback );


    /**
     * Utility class to get the RPC Async interface from client-side code
     */
    public static final class Util 
    { 
        private static IngestServiceAsync instance;

        public static final IngestServiceAsync getInstance()
        {
            if ( instance == null )
            {
                instance = (IngestServiceAsync) GWT.create( IngestService.class );
            }
            return instance;
        }

        private Util()
        {
            // Utility class should not be instanciated
        }
    }
}
