/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.security.common.encryption.pgp;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchProviderException;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.bouncycastle.openpgp.PGPException;
import org.fao.fi.security.common.encryption.pgp.exceptions.KeyringException;
import org.fao.fi.security.common.encryption.pgp.exceptions.MissingOrBadKeyringException;
import org.fao.fi.security.common.utilities.FileUtils;
import org.fao.fi.security.common.utilities.LoggingClient;
import org.fao.fi.security.common.utilities.pgp.PGPDecryptor;
import org.fao.fi.security.common.utilities.pgp.configuration.SecretKeyringConfiguration;

public class PGPDecryptorBean
extends LoggingClient {
    @Inject
    private PGPDecryptor _delegate;
    @Inject
    @Named(value="pgp.secret.krcfg")
    private SecretKeyringConfiguration _secretKeyringConfigurator;

    public PGPDecryptorBean() {
    }

    public PGPDecryptorBean(SecretKeyringConfiguration secretKeyringConfigurator) {
        this._delegate = new PGPDecryptor();
        this._secretKeyringConfigurator = secretKeyringConfigurator;
    }

    @PostConstruct
    private void validate() {
        if (this._delegate == null) {
            throw new IllegalArgumentException("The delegate PGP decryptor cannot be null");
        }
        if (this._secretKeyringConfigurator == null) {
            throw new IllegalArgumentException("The secret keyring configurator cannot be null");
        }
    }

    public byte[] decryptBytes(byte[] encodedData) throws IOException, KeyringException, PGPException, NoSuchProviderException {
        return this._delegate.decryptBytes(encodedData, this.streamSecretKeyring(this._secretKeyringConfigurator.getKeyringResourceURL()), this._secretKeyringConfigurator.getKeyringPassphrase());
    }

    public void decryptStream(InputStream encryptedStream, OutputStream decryptedStream) throws IOException, KeyringException, PGPException, NoSuchProviderException {
        this._delegate.decryptStream(encryptedStream, decryptedStream, this.streamSecretKeyring(this._secretKeyringConfigurator.getKeyringResourceURL()), this._secretKeyringConfigurator.getKeyringPassphrase().toCharArray());
    }

    private InputStream streamSecretKeyring(String secretKeyringResourceURL) throws MissingOrBadKeyringException, PGPException {
        if (secretKeyringResourceURL == null) {
            this._log.error("No keyring resource URL provided");
            throw new MissingOrBadKeyringException("No keyring resource URL provided");
        }
        InputStream secretKeyringStream = null;
        try {
            secretKeyringStream = FileUtils.streamResource(secretKeyringResourceURL);
        }
        catch (FileNotFoundException FNFe) {
            this._log.error("Cannot find secret keyring resource at URL {}: {}", (Object)secretKeyringResourceURL, (Object)FNFe.getMessage());
            throw new MissingOrBadKeyringException("No keyring available as a resource at URL " + secretKeyringResourceURL, FNFe);
        }
        catch (IOException IOe) {
            this._log.error("Unable to access secret keyring resource at URL {}: {} [ {} ]", new Object[]{secretKeyringResourceURL, IOe.getClass().getName(), IOe.getMessage()});
            throw new MissingOrBadKeyringException("Unable to access keyring as a resource at URL " + secretKeyringResourceURL + ": " + IOe.getMessage(), IOe);
        }
        if (secretKeyringStream == null) {
            this._log.error("No secret keyring available as a resource at URL {}", (Object)secretKeyringResourceURL);
            throw new MissingOrBadKeyringException("No keyring available as a resource at URL " + secretKeyringResourceURL);
        }
        return secretKeyringStream;
    }
}

