/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.security.common.support.encryption;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import org.fao.fi.security.common.encryption.pgp.exceptions.KeyringException;
import org.fao.fi.security.common.services.spi.encryption.EncryptionService;

public class EncryptedOutputStreamWrapper
extends ByteArrayOutputStream {
    private OutputStream _wrapped;
    private EncryptionService _streamEncryptor;

    public EncryptedOutputStreamWrapper(OutputStream wrapped, EncryptionService streamEncryptor) {
        this._wrapped = wrapped;
        this._streamEncryptor = streamEncryptor;
    }

    @Override
    public void close() throws IOException {
        this.flush();
        ByteArrayInputStream bufferedBytes = new ByteArrayInputStream(this.toByteArray());
        try {
            this._streamEncryptor.encrypt(bufferedBytes, this._wrapped);
        }
        catch (KeyringException e) {
            throw new IOException(e);
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
        bufferedBytes.close();
        super.close();
    }
}

