/**
 * (c) 2014 FAO / UN (project: fi-security-server)
 */
package org.fao.fi.security.server.providers.validators.token.impl.configuration;

import javax.enterprise.inject.Alternative;

import org.fao.fi.security.server.providers.validators.token.spi.TokenManagerConfigurator;

/**
 * Place your class / interface description here.
 *
 * History:
 *
 * ------------- --------------- -----------------------
 * Date			 Author			 Comment
 * ------------- --------------- -----------------------
 * 3 May 2014   Fiorellato     Creation.
 *
 * @version 1.0
 * @since 3 May 2014
 */
@Alternative
public class TokenManagerSimpleConfiguration implements TokenManagerConfigurator {
	private String _tokenCacheId;
	private int _tokenCacheSize;
	private int _tokenExpirationTime;
	
	/**
	 * Class constructor
	 */
	public TokenManagerSimpleConfiguration() {
		this("token.cache", 1000, 5);
	}
	
	/**
	 * Class constructor
	 */
	public TokenManagerSimpleConfiguration(int tokenCacheSize, int tokenExpirationTime) {
		this("token.cache", tokenCacheSize, tokenExpirationTime);
	}
	
	/**
	 * Class constructor
	 *
	 * @param tokenCacheId
	 * @param tokenCacheSize
	 * @param tokenExpirationTime
	 */
	public TokenManagerSimpleConfiguration(String tokenCacheId, int tokenCacheSize, int tokenExpirationTime) {
		super();
		this._tokenCacheId = tokenCacheId;
		this._tokenCacheSize = tokenCacheSize;
		this._tokenExpirationTime = tokenExpirationTime;
	}

	/* (non-Javadoc)
	 * @see org.fao.fi.security.server.providers.validators.token.spi.TokenManagerConfiguration#getTokenCacheId()
	 */
	@Override
	public String getTokenCacheId() {
		return this._tokenCacheId;
	}

	/* (non-Javadoc)
	 * @see org.fao.fi.security.server.providers.validators.token.spi.TokenManagerConfiguration#getTokenCacheSize()
	 */
	@Override
	public int getTokenCacheSize() {
		return this._tokenCacheSize;
	}

	/* (non-Javadoc)
	 * @see org.fao.fi.security.server.providers.validators.token.spi.TokenManagerConfiguration#getTokenExpirationTime()
	 */
	@Override
	public int getTokenExpirationTime() {
		return this._tokenExpirationTime;
	}
}