/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.security.server.providers.validators.token.spi;

import java.util.List;
import javax.ws.rs.container.ContainerRequestContext;
import org.fao.fi.security.common.services.exceptions.BadRequestException;
import org.fao.fi.security.common.services.exceptions.token.InvalidTokenException;
import org.fao.fi.security.common.services.exceptions.token.MissingTokenException;
import org.fao.fi.security.common.services.exceptions.token.TokenProcessingException;
import org.fao.fi.security.common.support.token.spi.TokenProcessor;
import org.fao.fi.security.common.utilities.LoggingClient;
import org.fao.fi.security.server.providers.validators.SecuredResourceValidationServiceProvider;
import org.fao.fi.security.server.providers.validators.token.spi.TokenConsumer;
import org.fao.fi.security.server.providers.validators.token.spi.TokenManager;

public abstract class AbstractTokenConsumer
extends LoggingClient
implements TokenConsumer,
SecuredResourceValidationServiceProvider {
    private TokenManager _tokenManager;
    private TokenProcessor _tokenProcessor;

    public AbstractTokenConsumer(TokenManager tokenManager, TokenProcessor tokenProcessor) {
        this._tokenManager = tokenManager;
        this._tokenProcessor = tokenProcessor;
    }

    @Override
    public synchronized boolean validate(ContainerRequestContext request) throws BadRequestException {
        try {
            this.consumeTokenIfValid(this.process(this.extractToken(request)));
            return true;
        }
        catch (InvalidTokenException ITe) {
            return false;
        }
        catch (Throwable t) {
            throw new BadRequestException(t.getMessage());
        }
    }

    @Override
    public synchronized void consumeTokenIfValid(String token) throws InvalidTokenException {
        if (!this.isTokenValid(token)) {
            throw new InvalidTokenException("Provided token is invalid!");
        }
        this._tokenManager.remove(token);
    }

    @Override
    public String extractToken(ContainerRequestContext request) throws MissingTokenException {
        List tokenHeaders = (List)request.getHeaders().get((Object)"fi-security-token");
        if (tokenHeaders == null || tokenHeaders.isEmpty()) {
            throw new MissingTokenException("No token header available");
        }
        String tokenHeader = null;
        for (String header : tokenHeaders) {
            if (header == null) continue;
            tokenHeader = header;
            break;
        }
        if (tokenHeader == null || "".equals(tokenHeader)) {
            throw new MissingTokenException("Token header is available but it has no value");
        }
        return tokenHeader;
    }

    @Override
    public synchronized boolean isTokenValid(String token) throws InvalidTokenException {
        return token != null && this._tokenManager.exists(token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String process(String token) throws TokenProcessingException {
        long start = System.currentTimeMillis();
        try {
            this._log.info("Beginning token processment...");
            String string = this._tokenProcessor.processBeforeConsumption(token);
            return string;
        }
        finally {
            long end = System.currentTimeMillis();
            this._log.info("Token processment has completed in {} mSec.", (Object)(end - start));
        }
    }
}

