/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.api;

import com.google.common.base.Function;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;

public interface Tree {
    public static final Tree[] EMPTY_ARRAY = new Tree[0];
    public static final Function<Tree, String> GET_NAME = new Function<Tree, String>(){

        @Override
        @Nullable
        public String apply(@Nullable Tree input) {
            if (input != null) {
                return input.getName();
            }
            return null;
        }
    };

    @Nonnull
    public String getName();

    public boolean isRoot();

    @Nonnull
    public String getPath();

    @Nonnull
    public Status getStatus();

    public boolean exists();

    @Nonnull
    public Tree getParent();

    @CheckForNull
    public PropertyState getProperty(@Nonnull String var1);

    @CheckForNull
    public Status getPropertyStatus(@Nonnull String var1);

    public boolean hasProperty(@Nonnull String var1);

    public long getPropertyCount();

    @Nonnull
    public Iterable<? extends PropertyState> getProperties();

    @Nonnull
    public Tree getChild(@Nonnull String var1) throws IllegalArgumentException;

    public boolean hasChild(@Nonnull String var1);

    public long getChildrenCount(long var1);

    @Nonnull
    public Iterable<Tree> getChildren();

    public boolean remove();

    @Nonnull
    public Tree addChild(@Nonnull String var1) throws IllegalArgumentException;

    public void setOrderableChildren(boolean var1);

    public boolean orderBefore(@Nullable String var1);

    public void setProperty(@Nonnull PropertyState var1);

    public <T> void setProperty(@Nonnull String var1, @Nonnull T var2) throws IllegalArgumentException;

    public <T> void setProperty(@Nonnull String var1, @Nonnull T var2, Type<T> var3) throws IllegalArgumentException;

    public void removeProperty(@Nonnull String var1);

    public static enum Status {
        UNCHANGED,
        NEW,
        MODIFIED;

    }
}

