/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.lock;

import java.util.Set;
import javax.annotation.Nonnull;
import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.lock.LockManager;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.jcr.delegate.NodeDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.SessionDelegate;
import org.apache.jackrabbit.oak.jcr.lock.LockImpl;
import org.apache.jackrabbit.oak.jcr.lock.LockOperation;
import org.apache.jackrabbit.oak.jcr.session.SessionContext;
import org.apache.jackrabbit.oak.jcr.session.operation.SessionOperation;

public class LockManagerImpl
implements LockManager {
    private final SessionContext sessionContext;
    private final SessionDelegate delegate;

    public LockManagerImpl(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
        this.delegate = sessionContext.getSessionDelegate();
    }

    @Override
    @Nonnull
    public String[] getLockTokens() throws RepositoryException {
        return this.perform(new SessionOperation<String[]>("getLockTokens"){

            @Override
            @Nonnull
            public String[] perform() {
                Set<String> tokens = LockManagerImpl.this.sessionContext.getOpenScopedLocks();
                return tokens.toArray(new String[tokens.size()]);
            }
        });
    }

    @Override
    public void addLockToken(final String lockToken) throws RepositoryException {
        try {
            this.perform(new LockOperation<String>(this.sessionContext, lockToken, "addLockToken"){

                @Override
                protected String perform(NodeDelegate node) throws LockException {
                    if (node.holdsLock(false)) {
                        String token = node.getPath();
                        LockManagerImpl.this.sessionContext.getOpenScopedLocks().add(token);
                        return null;
                    }
                    throw new LockException("Invalid lock token: " + lockToken);
                }
            });
        }
        catch (IllegalArgumentException e) {
            throw new LockException("Invalid lock token: " + lockToken);
        }
    }

    @Override
    public void removeLockToken(final String lockToken) throws RepositoryException {
        if (!this.perform(new SessionOperation<Boolean>("removeLockToken"){

            @Override
            @Nonnull
            public Boolean perform() {
                return LockManagerImpl.this.sessionContext.getOpenScopedLocks().remove(lockToken);
            }
        }).booleanValue()) {
            throw new LockException("Lock token " + lockToken + " is not held by this session");
        }
    }

    @Override
    public boolean isLocked(String absPath) throws RepositoryException {
        return this.perform(new LockOperation<Boolean>(this.sessionContext, absPath, "isLocked"){

            @Override
            protected Boolean perform(NodeDelegate node) {
                return node.isLocked();
            }
        });
    }

    @Override
    public boolean holdsLock(String absPath) throws RepositoryException {
        return this.perform(new LockOperation<Boolean>(this.sessionContext, absPath, "holdsLock"){

            @Override
            protected Boolean perform(NodeDelegate node) {
                return node.holdsLock(false);
            }
        });
    }

    @Override
    @Nonnull
    public Lock getLock(String absPath) throws RepositoryException {
        NodeDelegate lock = this.perform(new LockOperation<NodeDelegate>(this.sessionContext, absPath, "getLock"){

            @Override
            protected NodeDelegate perform(NodeDelegate node) {
                return node.getLock();
            }
        });
        if (lock != null) {
            return new LockImpl(this.sessionContext, lock);
        }
        throw new LockException("Node " + absPath + " is not locked");
    }

    @Override
    @Nonnull
    public Lock lock(String absPath, final boolean isDeep, final boolean isSessionScoped, long timeoutHint, String ownerInfo) throws RepositoryException {
        return new LockImpl(this.sessionContext, this.perform(new LockOperation<NodeDelegate>(this.sessionContext, absPath, "lock"){

            @Override
            protected NodeDelegate perform(NodeDelegate node) throws RepositoryException {
                if (node.getStatus() != Tree.Status.UNCHANGED) {
                    throw new InvalidItemStateException("Unable to lock a node with pending changes");
                }
                node.lock(isDeep);
                String path = node.getPath();
                if (isSessionScoped) {
                    LockManagerImpl.this.sessionContext.getSessionScopedLocks().add(path);
                } else {
                    LockManagerImpl.this.sessionContext.getOpenScopedLocks().add(path);
                }
                this.session.refresh(true);
                return node;
            }
        }));
    }

    @Override
    public void unlock(String absPath) throws RepositoryException {
        this.perform(new LockOperation<Void>(this.sessionContext, absPath, "unlock"){

            @Override
            protected Void perform(NodeDelegate node) throws RepositoryException {
                String path = node.getPath();
                if (this.canUnlock(path, node)) {
                    node.unlock();
                    LockManagerImpl.this.sessionContext.getSessionScopedLocks().remove(path);
                    LockManagerImpl.this.sessionContext.getOpenScopedLocks().remove(path);
                    this.session.refresh(true);
                    return null;
                }
                throw new LockException("Not an owner of the lock " + path);
            }

            private boolean canUnlock(String path, NodeDelegate node) {
                if (LockManagerImpl.this.sessionContext.getSessionScopedLocks().contains(path) || LockManagerImpl.this.sessionContext.getOpenScopedLocks().contains(path)) {
                    return true;
                }
                if (LockManagerImpl.this.sessionContext.getAttributes().get("oak.relaxed-locking") == Boolean.TRUE) {
                    String user = LockManagerImpl.this.sessionContext.getSessionDelegate().getAuthInfo().getUserID();
                    return node.isLockOwner(user) || LockManagerImpl.this.isAdmin(LockManagerImpl.this.sessionContext, user);
                }
                return false;
            }
        });
    }

    private boolean isAdmin(SessionContext sessionContext, String user) {
        try {
            Authorizable a = sessionContext.getUserManager().getAuthorizable(user);
            if (a != null && !a.isGroup()) {
                return ((User)a).isAdmin();
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return false;
    }

    private <T> T perform(SessionOperation<T> operation) throws RepositoryException {
        return this.delegate.perform(operation);
    }
}

