/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.rdb;

import com.google.common.base.Objects;
import com.google.common.cache.Cache;
import com.google.common.util.concurrent.Striped;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.Lock;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.mk.api.MicroKernelException;
import org.apache.jackrabbit.oak.cache.CacheStats;
import org.apache.jackrabbit.oak.cache.CacheValue;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.Document;
import org.apache.jackrabbit.oak.plugins.document.DocumentMK;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.StableRevisionComparator;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.UpdateUtils;
import org.apache.jackrabbit.oak.plugins.document.cache.CachingDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.util.StringValue;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDBDocumentStore
implements CachingDocumentStore {
    private final String MODIFIED = "_modified";
    private final String MODCOUNT = "_modCount";
    private static final Logger LOG = LoggerFactory.getLogger(RDBDocumentStore.class);
    private final Comparator<Revision> comparator = StableRevisionComparator.REVERSE;
    private Exception callStack;
    private DataSource ds;
    private static int DATALIMIT = 4096;
    private static int RETRIES = 10;
    private Cache<CacheValue, NodeDocument> nodesCache;
    private CacheStats cacheStats;
    private final Striped<Lock> locks = Striped.lock(64);

    public RDBDocumentStore(DataSource ds, DocumentMK.Builder builder) {
        try {
            this.initialize(ds, builder);
        }
        catch (Exception ex) {
            throw new MicroKernelException("initializing RDB document store", ex);
        }
    }

    @Override
    public <T extends Document> T find(Collection<T> collection, String id) {
        return this.find(collection, id, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Document> T find(final Collection<T> collection, final String id, int maxCacheAge) {
        NodeDocument doc;
        if (collection != Collection.NODES) {
            return this.readDocument(collection, id);
        }
        StringValue cacheKey = new StringValue(id);
        if (maxCacheAge > 0 && (doc = this.nodesCache.getIfPresent(cacheKey)) != null && (maxCacheAge == Integer.MAX_VALUE || System.currentTimeMillis() - doc.getCreated() < (long)maxCacheAge)) {
            return RDBDocumentStore.castAsT(RDBDocumentStore.unwrap(doc));
        }
        try {
            Lock lock = this.getAndLock(id);
            try {
                if (maxCacheAge == 0) {
                    this.invalidateCache(collection, id);
                }
                while (true) {
                    doc = this.nodesCache.get(cacheKey, new Callable<NodeDocument>(){

                        @Override
                        public NodeDocument call() throws Exception {
                            NodeDocument doc = (NodeDocument)RDBDocumentStore.this.readDocument(collection, id);
                            if (doc != null) {
                                doc.seal();
                            }
                            return RDBDocumentStore.wrap(doc);
                        }
                    });
                    if (maxCacheAge == 0) break;
                    if (maxCacheAge == Integer.MAX_VALUE) {
                        break;
                    }
                    if (System.currentTimeMillis() - doc.getCreated() < (long)maxCacheAge) {
                        break;
                    }
                    this.invalidateCache(collection, id);
                }
            }
            finally {
                lock.unlock();
            }
            return RDBDocumentStore.castAsT(RDBDocumentStore.unwrap(doc));
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Failed to load document with " + id, e);
        }
    }

    @Override
    public <T extends Document> List<T> query(Collection<T> collection, String fromKey, String toKey, int limit) {
        return this.query(collection, fromKey, toKey, null, 0L, limit);
    }

    @Override
    public <T extends Document> List<T> query(Collection<T> collection, String fromKey, String toKey, String indexedProperty, long startValue, int limit) {
        return this.internalQuery(collection, fromKey, toKey, indexedProperty, startValue, limit);
    }

    @Override
    public <T extends Document> void remove(Collection<T> collection, String id) {
        this.delete(collection, id);
        this.invalidateCache(collection, id);
    }

    @Override
    public <T extends Document> void remove(Collection<T> collection, List<String> keys) {
        for (String key : keys) {
            this.remove(collection, key);
        }
    }

    @Override
    public <T extends Document> boolean create(Collection<T> collection, List<UpdateOp> updateOps) {
        return this.internalCreate(collection, updateOps);
    }

    @Override
    public <T extends Document> void update(Collection<T> collection, List<String> keys, UpdateOp updateOp) {
        this.internalUpdate(collection, keys, updateOp);
    }

    @Override
    public <T extends Document> T createOrUpdate(Collection<T> collection, UpdateOp update) throws MicroKernelException {
        return this.internalCreateOrUpdate(collection, update, true, false);
    }

    @Override
    public <T extends Document> T findAndUpdate(Collection<T> collection, UpdateOp update) throws MicroKernelException {
        return this.internalCreateOrUpdate(collection, update, false, true);
    }

    @Override
    public void invalidateCache() {
        this.nodesCache.invalidateAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Document> void invalidateCache(Collection<T> collection, String id) {
        if (collection == Collection.NODES) {
            Lock lock = this.getAndLock(id);
            try {
                this.nodesCache.invalidate(new StringValue(id));
            }
            finally {
                lock.unlock();
            }
        }
    }

    @Override
    public void dispose() {
        this.ds = null;
    }

    @Override
    public <T extends Document> T getIfCached(Collection<T> collection, String id) {
        if (collection != Collection.NODES) {
            return null;
        }
        NodeDocument doc = this.nodesCache.getIfPresent(new StringValue(id));
        return RDBDocumentStore.castAsT(doc);
    }

    @Override
    public CacheStats getCacheStats() {
        return this.cacheStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(DataSource ds, DocumentMK.Builder builder) throws Exception {
        this.ds = ds;
        this.callStack = LOG.isDebugEnabled() ? new Exception("call stack of RDBDocumentStore creation") : null;
        this.nodesCache = builder.buildCache(builder.getDocumentCacheSize());
        this.cacheStats = new CacheStats(this.nodesCache, "Document-Documents", builder.getWeigher(), builder.getDocumentCacheSize());
        Connection con = ds.getConnection();
        try {
            con.setAutoCommit(false);
            for (String tableName : new String[]{"CLUSTERNODES", "NODES", "SETTINGS"}) {
                try {
                    PreparedStatement stmt = con.prepareStatement("select ID from " + tableName + " where ID = ?");
                    stmt.setString(1, "0:/");
                    stmt.executeQuery();
                }
                catch (SQLException ex) {
                    con.rollback();
                    String dbtype = con.getMetaData().getDatabaseProductName();
                    LOG.info("Attempting to create table " + tableName + " in " + dbtype);
                    Statement stmt = con.createStatement();
                    if ("PostgreSQL".equals(dbtype)) {
                        stmt.execute("create table " + tableName + " (ID varchar(1000) not null primary key, MODIFIED bigint, MODCOUNT bigint, SIZE bigint, DATA varchar(16384), BDATA bytea)");
                    } else if ("DB2".equals(dbtype) || dbtype != null && dbtype.startsWith("DB2/")) {
                        stmt.execute("create table " + tableName + " (ID varchar(1000) not null primary key, MODIFIED bigint, MODCOUNT bigint, SIZE bigint, DATA varchar(16384), BDATA blob)");
                    } else {
                        stmt.execute("create table " + tableName + " (ID varchar(1000) not null primary key, MODIFIED bigint, MODCOUNT bigint, SIZE bigint, DATA varchar(16384), BDATA blob)");
                    }
                    stmt.close();
                    con.commit();
                }
            }
        }
        finally {
            con.close();
        }
    }

    public void finalize() {
        if (this.ds != null && this.callStack != null) {
            LOG.debug("finalizing RDBDocumentStore that was not disposed", (Throwable)this.callStack);
        }
    }

    @CheckForNull
    private <T extends Document> boolean internalCreate(Collection<T> collection, List<UpdateOp> updates) {
        try {
            for (UpdateOp update : updates) {
                T doc = collection.newDocument(this);
                update.increment("_modCount", 1L);
                UpdateUtils.applyChanges(doc, update, this.comparator);
                this.insertDocument(collection, doc);
                this.addToCache(collection, doc);
            }
            return true;
        }
        catch (MicroKernelException ex) {
            return false;
        }
    }

    @CheckForNull
    private <T extends Document> T internalCreateOrUpdate(Collection<T> collection, UpdateOp update, boolean allowCreate, boolean checkConditions) {
        T oldDoc = this.readDocument(collection, update.getId());
        if (oldDoc == null) {
            if (!allowCreate) {
                return null;
            }
            if (!update.isNew()) {
                throw new MicroKernelException("Document does not exist: " + update.getId());
            }
            T doc = collection.newDocument(this);
            if (checkConditions && !UpdateUtils.checkConditions(doc, update)) {
                return null;
            }
            update.increment("_modCount", 1L);
            UpdateUtils.applyChanges(doc, update, this.comparator);
            try {
                this.insertDocument(collection, doc);
                this.addToCache(collection, doc);
                return oldDoc;
            }
            catch (MicroKernelException ex) {
                oldDoc = this.readDocument(collection, update.getId());
                if (oldDoc == null) {
                    throw ex;
                }
                return this.internalUpdate(collection, update, oldDoc, checkConditions, RETRIES);
            }
        }
        return this.internalUpdate(collection, update, oldDoc, checkConditions, RETRIES);
    }

    @CheckForNull
    private <T extends Document> T internalUpdate(Collection<T> collection, UpdateOp update, T oldDoc, boolean checkConditions, int retries) {
        T doc = this.applyChanges(collection, oldDoc, update, checkConditions);
        if (doc == null) {
            return null;
        }
        boolean success = false;
        while (!success && retries > 0) {
            success = this.updateDocument(collection, doc, (Long)oldDoc.get("_modCount"));
            if (!success) {
                --retries;
                oldDoc = this.readDocument(collection, update.getId());
                doc = this.applyChanges(collection, oldDoc, update, checkConditions);
                if (doc != null) continue;
                return null;
            }
            this.applyToCache(collection, oldDoc, doc);
        }
        if (!success) {
            throw new MicroKernelException("failed update (race?)");
        }
        return oldDoc;
    }

    @CheckForNull
    private <T extends Document> T applyChanges(Collection<T> collection, T oldDoc, UpdateOp update, boolean checkConditions) {
        T doc = collection.newDocument(this);
        oldDoc.deepCopy((Document)doc);
        if (checkConditions && !UpdateUtils.checkConditions(doc, update)) {
            return null;
        }
        update.increment("_modCount", 1L);
        UpdateUtils.applyChanges(doc, update, this.comparator);
        ((Document)doc).seal();
        return doc;
    }

    @CheckForNull
    private <T extends Document> void internalUpdate(Collection<T> collection, List<String> ids, UpdateOp update) {
        Connection connection = null;
        String tableName = RDBDocumentStore.getTable(collection);
        try {
            connection = this.getConnection();
            for (String id : ids) {
                String in = this.dbRead(connection, tableName, id);
                if (in == null) {
                    throw new MicroKernelException(tableName + " " + id + " not found");
                }
                T doc = this.fromString(collection, in);
                Long oldmodcount = (Long)((Document)doc).get("_modCount");
                update.increment("_modCount", 1L);
                UpdateUtils.applyChanges(doc, update, this.comparator);
                String data = RDBDocumentStore.asString(doc);
                Long modified = (Long)((Document)doc).get("_modified");
                Long modcount = (Long)((Document)doc).get("_modCount");
                this.dbUpdate(connection, tableName, id, modified, modcount, oldmodcount, data);
                this.invalidateCache(collection, id);
            }
            connection.commit();
        }
        catch (Exception ex) {
            throw new MicroKernelException(ex);
        }
        finally {
            this.closeConnection(connection);
        }
    }

    private <T extends Document> List<T> internalQuery(Collection<T> collection, String fromKey, String toKey, String indexedProperty, long startValue, int limit) {
        Connection connection = null;
        String tableName = RDBDocumentStore.getTable(collection);
        ArrayList<T> result = new ArrayList<T>();
        if (indexedProperty != null && !"_modified".equals(indexedProperty)) {
            throw new MicroKernelException("indexed property " + indexedProperty + " not supported");
        }
        try {
            connection = this.getConnection();
            List<String> dbresult = this.dbQuery(connection, tableName, fromKey, toKey, indexedProperty, startValue, limit);
            for (String data : dbresult) {
                T doc = this.fromString(collection, data);
                ((Document)doc).seal();
                result.add(doc);
                this.addToCacheIfNotNewer(collection, doc);
            }
        }
        catch (Exception ex) {
            throw new MicroKernelException(ex);
        }
        finally {
            this.closeConnection(connection);
        }
        return result;
    }

    private static <T extends Document> String getTable(Collection<T> collection) {
        if (collection == Collection.CLUSTER_NODES) {
            return "CLUSTERNODES";
        }
        if (collection == Collection.NODES) {
            return "NODES";
        }
        if (collection == Collection.SETTINGS) {
            return "SETTINGS";
        }
        throw new IllegalArgumentException("Unknown collection: " + collection.toString());
    }

    private static String asString(@Nonnull Document doc) {
        JSONObject obj = new JSONObject();
        for (String key : doc.keySet()) {
            Object value = doc.get(key);
            obj.put((Object)key, value);
        }
        return obj.toJSONString();
    }

    private <T extends Document> T fromString(Collection<T> collection, String data) throws ParseException {
        T doc = collection.newDocument(this);
        Map obj = (Map)new JSONParser().parse(data);
        for (Map.Entry entry : obj.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value == null) {
                ((Document)doc).put(key, value);
                continue;
            }
            if (value instanceof Boolean || value instanceof Long || value instanceof String) {
                ((Document)doc).put(key, value);
                continue;
            }
            if (value instanceof JSONObject) {
                ((Document)doc).put(key, this.convertJsonObject((JSONObject)value));
                continue;
            }
            throw new RuntimeException("unexpected type: " + value.getClass());
        }
        return doc;
    }

    @Nonnull
    private Map<Revision, Object> convertJsonObject(@Nonnull JSONObject obj) {
        TreeMap<Revision, Object> map = new TreeMap<Revision, Object>(this.comparator);
        Set entries = obj.entrySet();
        for (Map.Entry entry : entries) {
            map.put(Revision.fromString(entry.getKey().toString()), entry.getValue());
        }
        return map;
    }

    @CheckForNull
    private <T extends Document> T readDocument(Collection<T> collection, String id) {
        Connection connection = null;
        String tableName = RDBDocumentStore.getTable(collection);
        try {
            connection = this.getConnection();
            String in = this.dbRead(connection, tableName, id);
            T t = in != null ? (T)this.fromString(collection, in) : null;
            return t;
        }
        catch (Exception ex) {
            throw new MicroKernelException(ex);
        }
        finally {
            this.closeConnection(connection);
        }
    }

    private <T extends Document> void delete(Collection<T> collection, String id) {
        Connection connection = null;
        String tableName = RDBDocumentStore.getTable(collection);
        try {
            connection = this.getConnection();
            this.dbDelete(connection, tableName, id);
            connection.commit();
        }
        catch (Exception ex) {
            throw new MicroKernelException(ex);
        }
        finally {
            this.closeConnection(connection);
        }
    }

    private <T extends Document> boolean updateDocument(@Nonnull Collection<T> collection, @Nonnull T document, Long oldmodcount) {
        Connection connection = null;
        String tableName = RDBDocumentStore.getTable(collection);
        try {
            connection = this.getConnection();
            String data = RDBDocumentStore.asString(document);
            Long modified = (Long)document.get("_modified");
            Long modcount = (Long)document.get("_modCount");
            boolean success = this.dbUpdate(connection, tableName, document.getId(), modified, modcount, oldmodcount, data);
            connection.commit();
            boolean bl = success;
            return bl;
        }
        catch (SQLException ex) {
            try {
                connection.rollback();
            }
            catch (SQLException e) {
                // empty catch block
            }
            throw new MicroKernelException(ex);
        }
        finally {
            this.closeConnection(connection);
        }
    }

    private <T extends Document> void insertDocument(Collection<T> collection, T document) {
        Connection connection = null;
        String tableName = RDBDocumentStore.getTable(collection);
        try {
            connection = this.getConnection();
            String data = RDBDocumentStore.asString(document);
            Long modified = (Long)document.get("_modified");
            Long modcount = (Long)document.get("_modCount");
            this.dbInsert(connection, tableName, document.getId(), modified, modcount, data);
            connection.commit();
        }
        catch (SQLException ex) {
            LOG.debug("insert of " + document.getId() + " failed", (Throwable)ex);
            try {
                connection.rollback();
            }
            catch (SQLException e) {
                // empty catch block
            }
            throw new MicroKernelException(ex);
        }
        finally {
            this.closeConnection(connection);
        }
    }

    private String getData(ResultSet rs, int stringIndex, int blobIndex) throws SQLException {
        try {
            String data = rs.getString(stringIndex);
            byte[] bdata = rs.getBytes(blobIndex);
            if (bdata == null) {
                return data;
            }
            return IOUtils.toString(bdata, "UTF-8");
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    private static ByteArrayInputStream asInputStream(String data) {
        try {
            return new ByteArrayInputStream(data.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            LOG.error("This REALLY is not supposed to happen", (Throwable)ex);
            return null;
        }
    }

    @CheckForNull
    private String dbRead(Connection connection, String tableName, String id) throws SQLException {
        PreparedStatement stmt = connection.prepareStatement("select DATA, BDATA from " + tableName + " where ID = ?");
        try {
            stmt.setString(1, id);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                String string = this.getData(rs, 1, 2);
                return string;
            }
            String string = null;
            return string;
        }
        catch (SQLException ex) {
            LOG.error("attempting to read " + id + " (id length is " + id.length() + ")", (Throwable)ex);
            if ("22001".equals(ex.getSQLState())) {
                connection.rollback();
                String string = null;
                return string;
            }
            throw ex;
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> dbQuery(Connection connection, String tableName, String minId, String maxId, String indexedProperty, long startValue, int limit) throws SQLException {
        String t = "select DATA, BDATA from " + tableName + " where ID > ? and ID < ?";
        if (indexedProperty != null) {
            t = t + " and MODIFIED >= ?";
        }
        t = t + " order by ID";
        if (limit != Integer.MAX_VALUE) {
            t = t + " limit ?";
        }
        PreparedStatement stmt = connection.prepareStatement(t);
        ArrayList<String> result = new ArrayList<String>();
        try {
            int si = 1;
            stmt.setString(si++, minId);
            stmt.setString(si++, maxId);
            if (indexedProperty != null) {
                stmt.setLong(si++, startValue);
            }
            if (limit != Integer.MAX_VALUE) {
                stmt.setInt(si++, limit);
            }
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                String data = this.getData(rs, 1, 2);
                result.add(data);
            }
        }
        finally {
            stmt.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dbUpdate(Connection connection, String tableName, String id, Long modified, Long modcount, Long oldmodcount, String data) throws SQLException {
        String t = "update " + tableName + " set MODIFIED = ?, MODCOUNT = ?, SIZE = ?, DATA = ?, BDATA = ? where ID = ?";
        if (oldmodcount != null) {
            t = t + " and MODCOUNT = ?";
        }
        PreparedStatement stmt = connection.prepareStatement(t);
        try {
            int result;
            int si = 1;
            stmt.setObject(si++, (Object)modified, -5);
            stmt.setObject(si++, (Object)modcount, -5);
            stmt.setObject(si++, (Object)data.length(), -5);
            if (data.length() < DATALIMIT) {
                stmt.setString(si++, data);
                stmt.setBinaryStream(si++, (InputStream)null, 0);
            } else {
                stmt.setString(si++, "truncated...:" + data.substring(0, 1023));
                ByteArrayInputStream bis = RDBDocumentStore.asInputStream(data);
                stmt.setBinaryStream(si++, (InputStream)bis, bis.available());
            }
            stmt.setString(si++, id);
            if (oldmodcount != null) {
                stmt.setObject(si++, (Object)oldmodcount, -5);
            }
            if ((result = stmt.executeUpdate()) != 1) {
                LOG.debug("DB update failed for " + tableName + "/" + id + " with oldmodcount=" + oldmodcount);
            }
            boolean bl = result == 1;
            return bl;
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dbInsert(Connection connection, String tableName, String id, Long modified, Long modcount, String data) throws SQLException {
        PreparedStatement stmt = connection.prepareStatement("insert into " + tableName + " values(?, ?, ?, ?, ?, ?)");
        try {
            int si = 1;
            stmt.setString(si++, id);
            stmt.setObject(si++, (Object)modified, -5);
            stmt.setObject(si++, (Object)modcount, -5);
            stmt.setObject(si++, (Object)data.length(), -5);
            if (data.length() < DATALIMIT) {
                stmt.setString(si++, data);
                stmt.setBinaryStream(si++, (InputStream)null, 0);
            } else {
                stmt.setString(si++, "truncated...:" + data.substring(0, 1023));
                ByteArrayInputStream bis = RDBDocumentStore.asInputStream(data);
                stmt.setBinaryStream(si++, (InputStream)bis, bis.available());
            }
            int result = stmt.executeUpdate();
            if (result != 1) {
                LOG.debug("DB insert failed for " + tableName + "/" + id);
            }
            boolean bl = result == 1;
            return bl;
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dbDelete(Connection connection, String tableName, String id) throws SQLException {
        PreparedStatement stmt = connection.prepareStatement("delete from " + tableName + " where ID = ?");
        try {
            stmt.setString(1, id);
            int result = stmt.executeUpdate();
            if (result != 1) {
                LOG.debug("DB delete failed for " + tableName + "/" + id);
            }
            boolean bl = result == 1;
            return bl;
        }
        finally {
            stmt.close();
        }
    }

    @Override
    public void setReadWriteMode(String readWriteMode) {
    }

    private static <T extends Document> T castAsT(NodeDocument doc) {
        return (T)doc;
    }

    private Lock getAndLock(String key) {
        Lock l = this.locks.get(key);
        l.lock();
        return l;
    }

    @CheckForNull
    private static NodeDocument unwrap(@Nonnull NodeDocument doc) {
        return doc == NodeDocument.NULL ? null : doc;
    }

    @Nonnull
    private static NodeDocument wrap(@CheckForNull NodeDocument doc) {
        return doc == null ? NodeDocument.NULL : doc;
    }

    @Nonnull
    private NodeDocument addToCache(final @Nonnull NodeDocument doc) {
        if (doc == NodeDocument.NULL) {
            throw new IllegalArgumentException("doc must not be NULL document");
        }
        doc.seal();
        try {
            StringValue key = new StringValue(doc.getId());
            while (true) {
                NodeDocument cached;
                if ((cached = this.nodesCache.get(key, new Callable<NodeDocument>(){

                    @Override
                    public NodeDocument call() {
                        return doc;
                    }
                })) != NodeDocument.NULL) {
                    return cached;
                }
                this.nodesCache.invalidate(key);
            }
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
    }

    @Nonnull
    private void applyToCache(@Nonnull NodeDocument oldDoc, @Nonnull NodeDocument newDoc) {
        NodeDocument cached = this.addToCache(newDoc);
        if (cached == newDoc) {
            return;
        }
        if (oldDoc == null) {
            return;
        }
        StringValue key = new StringValue(newDoc.getId());
        if (Objects.equal(cached.getModCount(), oldDoc.getModCount())) {
            this.nodesCache.put(key, newDoc);
        } else {
            this.nodesCache.invalidate(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Document> void addToCache(Collection<T> collection, T doc) {
        if (collection == Collection.NODES) {
            Lock lock = this.getAndLock(doc.getId());
            try {
                this.addToCache((NodeDocument)doc);
            }
            finally {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Document> void applyToCache(Collection<T> collection, T oldDoc, T newDoc) {
        if (collection == Collection.NODES) {
            Lock lock = this.getAndLock(newDoc.getId());
            try {
                this.applyToCache((NodeDocument)oldDoc, (NodeDocument)newDoc);
            }
            finally {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Document> void addToCacheIfNotNewer(Collection<T> collection, T doc) {
        if (collection == Collection.NODES) {
            String id = doc.getId();
            Lock lock = this.getAndLock(id);
            StringValue cacheKey = new StringValue(id);
            try {
                NodeDocument cached = this.nodesCache.getIfPresent(cacheKey);
                if (cached != null && cached != NodeDocument.NULL) {
                    Number cachedModCount = cached.getModCount();
                    Number modCount = doc.getModCount();
                    if (cachedModCount == null || modCount == null) {
                        throw new IllegalStateException("Missing _modCount");
                    }
                    if (modCount.longValue() > cachedModCount.longValue()) {
                        this.nodesCache.put(cacheKey, (NodeDocument)doc);
                    }
                } else {
                    this.nodesCache.put(cacheKey, (NodeDocument)doc);
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    private Connection getConnection() throws SQLException {
        Connection c = this.ds.getConnection();
        c.setAutoCommit(false);
        return c;
    }

    private void closeConnection(Connection c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

