/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.plugins.nodetype.ReadOnlyNodeTypeManager;
import org.apache.jackrabbit.oak.plugins.tree.TreeLocation;
import org.apache.jackrabbit.oak.plugins.value.ValueFactoryImpl;
import org.apache.jackrabbit.oak.security.user.AuthorizableImpl;
import org.apache.jackrabbit.oak.security.user.AuthorizableProperties;
import org.apache.jackrabbit.oak.util.NodeUtil;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AuthorizablePropertiesImpl
implements AuthorizableProperties {
    private static final Logger log = LoggerFactory.getLogger(AuthorizablePropertiesImpl.class);
    private final AuthorizableImpl authorizable;
    private final NamePathMapper namePathMapper;

    AuthorizablePropertiesImpl(AuthorizableImpl authorizable, NamePathMapper namePathMapper) {
        this.authorizable = authorizable;
        this.namePathMapper = namePathMapper;
    }

    @Override
    public Iterator<String> getNames(String relPath) throws RepositoryException {
        String oakPath = this.getOakPath(relPath);
        Tree tree = this.getTree();
        TreeLocation location = AuthorizablePropertiesImpl.getLocation(tree, oakPath);
        Tree parent = location.getTree();
        if (parent != null && Text.isDescendantOrEqual(tree.getPath(), parent.getPath())) {
            ArrayList<String> l = new ArrayList<String>();
            for (PropertyState propertyState : parent.getProperties()) {
                String propName = propertyState.getName();
                if (!this.isAuthorizableProperty(tree, location.getChild(propName), false)) continue;
                l.add(this.namePathMapper.getJcrName(propName));
            }
            return l.iterator();
        }
        throw new RepositoryException("Relative path " + relPath + " refers to items outside of scope of authorizable.");
    }

    @Override
    public boolean hasProperty(String relPath) throws RepositoryException {
        String oakPath = this.getOakPath(relPath);
        return this.isAuthorizableProperty(this.getTree(), AuthorizablePropertiesImpl.getLocation(this.getTree(), oakPath), true);
    }

    @Override
    public Value[] getProperty(String relPath) throws RepositoryException {
        String oakPath = this.getOakPath(relPath);
        Tree tree = this.getTree();
        Value[] values = null;
        PropertyState property = this.getAuthorizableProperty(tree, AuthorizablePropertiesImpl.getLocation(tree, oakPath), true);
        if (property != null) {
            if (property.isArray()) {
                List<Value> vs = ValueFactoryImpl.createValues(property, this.namePathMapper);
                values = vs.toArray(new Value[vs.size()]);
            } else {
                values = new Value[]{ValueFactoryImpl.createValue(property, this.namePathMapper)};
            }
        }
        return values;
    }

    @Override
    public void setProperty(String relPath, Value value) throws RepositoryException {
        if (value == null) {
            this.removeProperty(relPath);
        } else {
            String oakPath = this.getOakPath(relPath);
            String name = Text.getName(oakPath);
            PropertyState propertyState = PropertyStates.createProperty(name, value);
            String intermediate = oakPath.equals(name) ? null : Text.getRelativeParent(oakPath, 1);
            Tree parent = this.getOrCreateTargetTree(intermediate);
            this.checkProtectedProperty(parent, propertyState);
            parent.setProperty(propertyState);
        }
    }

    @Override
    public void setProperty(String relPath, Value[] values) throws RepositoryException {
        if (values == null) {
            this.removeProperty(relPath);
        } else {
            String oakPath = this.getOakPath(relPath);
            String name = Text.getName(oakPath);
            PropertyState propertyState = PropertyStates.createProperty(name, Arrays.asList(values));
            String intermediate = oakPath.equals(name) ? null : Text.getRelativeParent(oakPath, 1);
            Tree parent = this.getOrCreateTargetTree(intermediate);
            this.checkProtectedProperty(parent, propertyState);
            parent.setProperty(propertyState);
        }
    }

    @Override
    public boolean removeProperty(String relPath) throws RepositoryException {
        String oakPath = this.getOakPath(relPath);
        Tree node = this.getTree();
        TreeLocation propertyLocation = AuthorizablePropertiesImpl.getLocation(node, oakPath);
        if (propertyLocation.getProperty() != null) {
            if (this.isAuthorizableProperty(node, propertyLocation, true)) {
                return propertyLocation.remove();
            }
            throw new ConstraintViolationException("Property " + relPath + " isn't a modifiable authorizable property");
        }
        return false;
    }

    @Nonnull
    private Tree getTree() {
        return this.authorizable.getTree();
    }

    private boolean isAuthorizableProperty(Tree authorizableTree, TreeLocation propertyLocation, boolean verifyAncestor) throws RepositoryException {
        return this.getAuthorizableProperty(authorizableTree, propertyLocation, verifyAncestor) != null;
    }

    @CheckForNull
    private PropertyState getAuthorizableProperty(Tree authorizableTree, TreeLocation propertyLocation, boolean verifyAncestor) throws RepositoryException {
        if (propertyLocation == null) {
            return null;
        }
        PropertyState property = propertyLocation.getProperty();
        if (property == null) {
            return null;
        }
        String authorizablePath = authorizableTree.getPath();
        if (verifyAncestor && !Text.isDescendant(authorizablePath, propertyLocation.getPath())) {
            log.debug("Attempt to access property outside of authorizable scope.");
            return null;
        }
        Tree parent = propertyLocation.getParent().getTree();
        if (parent == null) {
            log.debug("Unable to determine definition of authorizable property at " + propertyLocation.getPath());
            return null;
        }
        ReadOnlyNodeTypeManager nodeTypeManager = this.authorizable.getUserManager().getNodeTypeManager();
        PropertyDefinition def = nodeTypeManager.getDefinition(parent, property, true);
        if (def.isProtected() || authorizablePath.equals(parent.getPath()) && !def.getDeclaringNodeType().isNodeType("rep:Authorizable")) {
            return null;
        }
        return property;
    }

    private void checkProtectedProperty(Tree parent, PropertyState property) throws RepositoryException {
        ReadOnlyNodeTypeManager nodeTypeManager = this.authorizable.getUserManager().getNodeTypeManager();
        PropertyDefinition def = nodeTypeManager.getDefinition(parent, property, false);
        if (def.isProtected()) {
            throw new ConstraintViolationException("Attempt to set an protected property " + property.getName());
        }
    }

    @Nonnull
    private Tree getOrCreateTargetTree(String relPath) throws RepositoryException {
        Tree targetTree;
        Tree userTree = this.getTree();
        if (relPath != null) {
            String userPath = userTree.getPath();
            targetTree = AuthorizablePropertiesImpl.getLocation(userTree, relPath).getTree();
            if (targetTree != null ? !Text.isDescendantOrEqual(userPath, targetTree.getPath()) : !Text.isDescendantOrEqual(userPath, (targetTree = new NodeUtil(userTree).getOrAddTree(relPath, "nt:unstructured").getTree()).getPath())) {
                throw new RepositoryException("Relative path " + relPath + " outside of scope of " + this);
            }
        } else {
            targetTree = userTree;
        }
        return targetTree;
    }

    @Nonnull
    private static TreeLocation getLocation(Tree tree, String relativePath) {
        TreeLocation loc = TreeLocation.create(tree);
        for (String element : Text.explode(relativePath, 47, false)) {
            if (PathUtils.denotesParent(element)) {
                loc = loc.getParent();
                continue;
            }
            if (PathUtils.denotesCurrent(element)) continue;
            loc = loc.getChild(element);
        }
        return loc;
    }

    private String getOakPath(String relPath) throws RepositoryException {
        if (relPath == null || relPath.isEmpty() || relPath.charAt(0) == '/') {
            throw new RepositoryException("Relative path expected. Found " + relPath);
        }
        String oakPath = this.namePathMapper.getOakPathKeepIndex(relPath);
        if (oakPath == null) {
            throw new RepositoryException("Failed to resolve relative path: " + relPath);
        }
        return oakPath;
    }
}

