/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.StackWindow;
import ij.measure.Calibration;
import ij.plugin.PlugIn;

public class Animator
implements PlugIn {
    private static double animationRate = Prefs.getDouble("fps", 7.0);
    private static int firstFrame = 0;
    private static int lastFrame = 0;
    private ImagePlus imp;
    private StackWindow swin;
    private int slice;
    private int nSlices;

    public void run(String arg) {
        this.imp = WindowManager.getCurrentImage();
        if (this.imp == null) {
            IJ.noImage();
            return;
        }
        this.nSlices = this.imp.getStackSize();
        if (this.nSlices < 2) {
            IJ.error("Stack required.");
            return;
        }
        ImageWindow win = this.imp.getWindow();
        if (win == null || !(win instanceof StackWindow)) {
            if (arg.equals("next")) {
                this.imp.setSlice(this.imp.getCurrentSlice() + 1);
            } else if (arg.equals("previous")) {
                this.imp.setSlice(this.imp.getCurrentSlice() - 1);
            }
            if (win != null) {
                this.imp.updateStatusbarValue();
            }
            return;
        }
        this.swin = (StackWindow)win;
        ImageStack stack = this.imp.getStack();
        this.slice = this.imp.getCurrentSlice();
        IJ.register(Animator.class);
        if (arg.equals("options")) {
            this.doOptions();
            return;
        }
        if (arg.equals("start")) {
            this.startAnimation();
            return;
        }
        if (this.swin.getAnimate()) {
            this.stopAnimation();
        }
        if (arg.equals("stop")) {
            return;
        }
        if (arg.equals("next")) {
            this.nextSlice();
            return;
        }
        if (arg.equals("previous")) {
            this.previousSlice();
            return;
        }
        if (arg.equals("set")) {
            this.setSlice();
            return;
        }
    }

    void stopAnimation() {
        this.swin.setAnimate(false);
        IJ.wait(500 + (int)(1000.0 / animationRate));
        this.imp.unlock();
    }

    void startAnimation() {
        int first = firstFrame;
        int last = lastFrame;
        if (first < 1 || first > this.nSlices || last < 1 || last > this.nSlices) {
            first = 1;
            last = this.nSlices;
        }
        if (this.swin.getAnimate()) {
            this.stopAnimation();
            return;
        }
        this.imp.unlock();
        this.swin.setAnimate(true);
        long nextTime = System.currentTimeMillis();
        Thread.currentThread().setPriority(1);
        int sliceIncrement = 1;
        Calibration cal = this.imp.getCalibration();
        if (cal.fps != 0.0) {
            animationRate = cal.fps;
        }
        if (animationRate < 0.1) {
            animationRate = 1.0;
        }
        int frames = this.imp.getNFrames();
        int slices = this.imp.getNSlices();
        if (this.imp.isDisplayedHyperStack() && frames > 1) {
            int frame = this.imp.getFrame();
            first = 1;
            last = frames;
            while (this.swin.getAnimate()) {
                long time = System.currentTimeMillis();
                if (time < nextTime) {
                    IJ.wait((int)(nextTime - time));
                } else {
                    Thread.yield();
                }
                nextTime += (long)(1000.0 / animationRate);
                if ((frame += sliceIncrement) < first) {
                    frame = first + 1;
                    sliceIncrement = 1;
                }
                if (frame > last) {
                    if (cal.loop) {
                        frame = last - 1;
                        sliceIncrement = -1;
                    } else {
                        frame = first;
                        sliceIncrement = 1;
                    }
                }
                this.imp.setPosition(this.imp.getChannel(), this.imp.getSlice(), frame);
            }
            return;
        }
        if (this.imp.isDisplayedHyperStack() && slices > 1) {
            this.slice = this.imp.getSlice();
            first = 1;
            last = slices;
            while (this.swin.getAnimate()) {
                long time = System.currentTimeMillis();
                if (time < nextTime) {
                    IJ.wait((int)(nextTime - time));
                } else {
                    Thread.yield();
                }
                nextTime += (long)(1000.0 / animationRate);
                this.slice += sliceIncrement;
                if (this.slice < first) {
                    this.slice = first + 1;
                    sliceIncrement = 1;
                }
                if (this.slice > last) {
                    if (cal.loop) {
                        this.slice = last - 1;
                        sliceIncrement = -1;
                    } else {
                        this.slice = first;
                        sliceIncrement = 1;
                    }
                }
                this.imp.setPosition(this.imp.getChannel(), this.slice, this.imp.getFrame());
            }
            return;
        }
        long startTime = System.currentTimeMillis();
        int count = 0;
        double fps = 0.0;
        while (this.swin.getAnimate()) {
            long time = System.currentTimeMillis();
            ++count;
            if (time > startTime + 1000L) {
                startTime = System.currentTimeMillis();
                fps = count;
                count = 0;
            }
            IJ.showStatus((int)(fps + 0.5) + " fps");
            if (time < nextTime) {
                IJ.wait((int)(nextTime - time));
            } else {
                Thread.yield();
            }
            nextTime += (long)(1000.0 / animationRate);
            this.slice += sliceIncrement;
            if (this.slice < first) {
                this.slice = first + 1;
                sliceIncrement = 1;
            }
            if (this.slice > last) {
                if (cal.loop) {
                    this.slice = last - 1;
                    sliceIncrement = -1;
                } else {
                    this.slice = first;
                    sliceIncrement = 1;
                }
            }
            this.swin.showSlice(this.slice);
        }
    }

    void doOptions() {
        if (firstFrame < 1 || firstFrame > this.nSlices || lastFrame < 1 || lastFrame > this.nSlices) {
            firstFrame = 1;
            lastFrame = this.nSlices;
        }
        if (this.imp.isDisplayedHyperStack()) {
            int frames = this.imp.getNFrames();
            int slices = this.imp.getNSlices();
            firstFrame = 1;
            if (frames > 1) {
                lastFrame = frames;
            } else if (slices > 1) {
                lastFrame = slices;
            }
        }
        boolean start = !this.swin.getAnimate();
        Calibration cal = this.imp.getCalibration();
        if (cal.fps != 0.0) {
            animationRate = cal.fps;
        } else if (cal.frameInterval != 0.0 && cal.getTimeUnit().equals("sec")) {
            animationRate = 1.0 / cal.frameInterval;
        }
        int decimalPlaces = (double)((int)animationRate) == animationRate ? 0 : 3;
        GenericDialog gd = new GenericDialog("Animation Options");
        gd.addNumericField("Speed (0.1-1000 fps):", animationRate, decimalPlaces);
        if (!this.imp.isDisplayedHyperStack()) {
            gd.addNumericField("First Frame:", firstFrame, 0);
            gd.addNumericField("Last Frame:", lastFrame, 0);
        }
        gd.addCheckbox("Loop Back and Forth", cal.loop);
        gd.addCheckbox("Start Animation", start);
        gd.showDialog();
        if (gd.wasCanceled()) {
            if (firstFrame == 1 && lastFrame == this.nSlices) {
                firstFrame = 0;
                lastFrame = 0;
            }
            return;
        }
        double speed = gd.getNextNumber();
        if (!this.imp.isDisplayedHyperStack()) {
            firstFrame = (int)gd.getNextNumber();
            lastFrame = (int)gd.getNextNumber();
        }
        if (firstFrame == 1 && lastFrame == this.nSlices) {
            firstFrame = 0;
            lastFrame = 0;
        }
        cal.loop = gd.getNextBoolean();
        Calibration.setLoopBackAndForth(cal.loop);
        start = gd.getNextBoolean();
        if (speed > 1000.0) {
            speed = 1000.0;
        }
        if ((animationRate = speed) != 0.0) {
            cal.fps = animationRate;
        }
        if (start && !this.swin.getAnimate()) {
            this.startAnimation();
        }
    }

    void nextSlice() {
        if (!this.imp.lock()) {
            return;
        }
        boolean hyperstack = this.imp.isDisplayedHyperStack();
        int channels = this.imp.getNChannels();
        int slices = this.imp.getNSlices();
        int frames = this.imp.getNFrames();
        if (hyperstack && channels > 1 && (slices <= 1 && frames <= 1 || !IJ.controlKeyDown() && !IJ.spaceBarDown() && !IJ.altKeyDown())) {
            int c = this.imp.getChannel() + 1;
            if (c > channels) {
                c = channels;
            }
            this.swin.setPosition(c, this.imp.getSlice(), this.imp.getFrame());
        } else if (hyperstack && slices > 1 && (frames <= 1 || !IJ.altKeyDown())) {
            int z = this.imp.getSlice() + 1;
            if (z > slices) {
                z = slices;
            }
            this.swin.setPosition(this.imp.getChannel(), z, this.imp.getFrame());
        } else if (hyperstack && frames > 1) {
            int t = this.imp.getFrame() + 1;
            if (t > frames) {
                t = frames;
            }
            this.swin.setPosition(this.imp.getChannel(), this.imp.getSlice(), t);
        } else {
            this.slice = IJ.altKeyDown() ? (this.slice += 10) : ++this.slice;
            if (this.slice > this.nSlices) {
                this.slice = this.nSlices;
            }
            this.swin.showSlice(this.slice);
        }
        this.imp.updateStatusbarValue();
        this.imp.unlock();
    }

    void previousSlice() {
        if (!this.imp.lock()) {
            return;
        }
        boolean hyperstack = this.imp.isDisplayedHyperStack();
        int channels = this.imp.getNChannels();
        int slices = this.imp.getNSlices();
        int frames = this.imp.getNFrames();
        if (hyperstack && channels > 1 && (slices <= 1 && frames <= 1 || !IJ.controlKeyDown() && !IJ.spaceBarDown() && !IJ.altKeyDown())) {
            int c = this.imp.getChannel() - 1;
            if (c < 1) {
                c = 1;
            }
            this.swin.setPosition(c, this.imp.getSlice(), this.imp.getFrame());
        } else if (hyperstack && slices > 1 && (frames <= 1 || !IJ.altKeyDown())) {
            int z = this.imp.getSlice() - 1;
            if (z < 1) {
                z = 1;
            }
            this.swin.setPosition(this.imp.getChannel(), z, this.imp.getFrame());
        } else if (hyperstack && frames > 1) {
            int t = this.imp.getFrame() - 1;
            if (t < 1) {
                t = 1;
            }
            this.swin.setPosition(this.imp.getChannel(), this.imp.getSlice(), t);
        } else {
            this.slice = IJ.altKeyDown() ? (this.slice -= 10) : --this.slice;
            if (this.slice < 1) {
                this.slice = 1;
            }
            this.swin.showSlice(this.slice);
        }
        this.imp.updateStatusbarValue();
        this.imp.unlock();
    }

    void setSlice() {
        GenericDialog gd = new GenericDialog("Set Slice");
        gd.addNumericField("Slice Number (1-" + this.nSlices + "):", this.slice, 0);
        gd.showDialog();
        if (!gd.wasCanceled()) {
            int n = (int)gd.getNextNumber();
            if (this.imp.isDisplayedHyperStack()) {
                this.imp.setPosition(n);
            } else {
                this.imp.setSlice(n);
            }
        }
    }

    public static double getFrameRate() {
        return animationRate;
    }
}

