/*
 * Decompiled with CFR 0.152.
 */
package lombok.core.configuration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.core.configuration.ConfigurationKey;
import lombok.core.configuration.ConfigurationResolver;
import lombok.core.configuration.ConfigurationSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BubblingConfigurationResolver
implements ConfigurationResolver {
    private final Iterable<ConfigurationSource> sources;

    public BubblingConfigurationResolver(Iterable<ConfigurationSource> sources) {
        this.sources = sources;
    }

    @Override
    public <T> T resolve(ConfigurationKey<T> key) {
        boolean isList = key.getType().isList();
        ArrayList<List> listModificationsList = null;
        for (ConfigurationSource source : this.sources) {
            ConfigurationSource.Result result = source.resolve(key);
            if (result == null) continue;
            if (isList) {
                if (listModificationsList == null) {
                    listModificationsList = new ArrayList<List>();
                }
                listModificationsList.add((List)result.getValue());
            }
            if (!result.isAuthoritative()) continue;
            if (isList) break;
            return (T)result.getValue();
        }
        if (!isList) {
            return null;
        }
        if (listModificationsList == null) {
            return (T)Collections.emptyList();
        }
        ArrayList<Object> listValues = new ArrayList<Object>();
        Collections.reverse(listModificationsList);
        for (List listModifications : listModificationsList) {
            if (listModifications == null) continue;
            for (ConfigurationSource.ListModification modification : listModifications) {
                listValues.remove(modification.getValue());
                if (!modification.isAdded()) continue;
                listValues.add(modification.getValue());
            }
        }
        return (T)listValues;
    }
}

