/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.util.config.easyconf;

import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.configuration.DatabaseConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gcube.common.homelibrary.util.config.easyconf.ConfigurationException;

public class DatasourceURL {
    private static final Log log = LogFactory.getLog(DatasourceURL.class);
    private static final String DATASOURCE_PREFIX = "datasource:";
    public static final String CONFIGURATION_OBJECTS_TABLE = "easyconf_configuration_objects";
    public static final String PROPERTIES_TABLE = "easyconf_properties";
    private static InitialContext ctx = null;
    private String dataSourceName;
    private String companyId;
    private String componentName;
    private String tableName;

    public DatasourceURL(String datasourcePath, String companyId, String componentName, String tableName) {
        this.dataSourceName = datasourcePath.substring(DATASOURCE_PREFIX.length());
        this.companyId = companyId;
        this.componentName = componentName;
        this.tableName = tableName;
    }

    public DataSource getDatasource() {
        try {
            DataSource ds = null;
            String[] dsFinders = new String[]{"java:/comp/env/" + this.dataSourceName, this.dataSourceName};
            for (int i = 0; i < dsFinders.length; ++i) {
                try {
                    ds = (DataSource)this.getContext().lookup(dsFinders[i]);
                    break;
                }
                catch (NameNotFoundException e) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Datasource " + this.dataSourceName + " not found", e);
                    continue;
                }
            }
            if (ds == null) {
                throw new ConfigurationException("Cannot find datasource: " + this.dataSourceName);
            }
            return ds;
        }
        catch (NamingException e) {
            throw new ConfigurationException("Error loading datasource " + this.dataSourceName);
        }
    }

    private synchronized InitialContext getContext() throws NamingException {
        if (ctx == null) {
            ctx = new InitialContext();
        }
        return ctx;
    }

    protected String getTableName() {
        return this.tableName;
    }

    protected String getComponentColumnName() {
        return "component";
    }

    protected String getKeyColumnName() {
        return "key";
    }

    protected String getValueColumnName() {
        return "value";
    }

    public static boolean isDatasource(String fileName) {
        if (fileName == null) {
            return false;
        }
        return fileName.startsWith(DATASOURCE_PREFIX);
    }

    public DatabaseConfiguration getConfiguration() {
        return new DatabaseConfiguration(this.getDatasource(), this.getTableName(), this.getComponentColumnName(), this.getKeyColumnName(), this.getValueColumnName(), this.getCompanyComponentValue());
    }

    private String getCompanyComponentValue() {
        if (this.companyId != null) {
            return this.companyId + ":" + this.componentName;
        }
        return this.componentName;
    }
}

