/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.commons;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.commons.ClassIntrospector;
import org.objectweb.asm.commons.ClassIntrospectorPerformance$Collector;

public class ClassIntrospectorPerformance {
    private List classes = new ArrayList();

    public ClassIntrospectorPerformance() throws IOException {
        String string = System.getProperty("asm.test") + ",";
        String string2 = System.getProperty("asm.test.class");
        String string3 = System.getProperty("parts");
        String string4 = System.getProperty("part");
        int n = string3 == null ? 1 : Integer.parseInt(string3);
        int n2 = string4 == null ? 0 : Integer.parseInt(string4);
        int n3 = 0;
        while (string.indexOf(44) != -1) {
            String string5 = string.substring(0, string.indexOf(44));
            string = string.substring(string.indexOf(44) + 1);
            File file = new File(string5);
            if (!file.isFile()) continue;
            ZipFile zipFile = new ZipFile(string5);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String string6 = zipEntry.getName();
                if (!string6.endsWith(".class")) continue;
                string6 = string6.substring(0, string6.length() - 6).replace('/', '.');
                if (string2 != null && string6.indexOf(string2) == -1) continue;
                if (n3 % n == n2) {
                    try {
                        Class<?> clazz = Class.forName(string6);
                        this.classes.add(clazz);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                ++n3;
            }
        }
    }

    protected void measureClassIntrospector(int n) {
        long l = System.currentTimeMillis();
        Iterator iterator = this.classes.iterator();
        while (iterator.hasNext()) {
            Class clazz = (Class)iterator.next();
            new ClassIntrospector().accept(new ClassIntrospectorPerformance$Collector(), clazz, n, 47);
        }
        long l2 = System.currentTimeMillis();
        System.err.println("ClassIntrospector " + n + " " + (float)(l2 - l) / 1000.0f);
    }

    protected void measureClassReader() throws IOException {
        long l = System.currentTimeMillis();
        Iterator iterator = this.classes.iterator();
        while (iterator.hasNext()) {
            Class clazz = (Class)iterator.next();
            InputStream inputStream = clazz.getResourceAsStream("/" + clazz.getName().replace('.', '/') + ".class");
            ClassReader classReader = new ClassReader(inputStream);
            inputStream.close();
            classReader.accept(new ClassIntrospectorPerformance$Collector(), 1);
        }
        long l2 = System.currentTimeMillis();
        System.err.println("ClassReader: " + (float)(l2 - l) / 1000.0f);
    }

    public static void main(String[] stringArray) throws IOException {
        ClassIntrospectorPerformance classIntrospectorPerformance = new ClassIntrospectorPerformance();
        int n = 146;
        classIntrospectorPerformance.measureClassIntrospector(n);
        classIntrospectorPerformance.measureClassIntrospector(n);
        classIntrospectorPerformance.measureClassReader();
        classIntrospectorPerformance.measureClassReader();
        classIntrospectorPerformance.measureClassIntrospector(n);
        classIntrospectorPerformance.measureClassIntrospector(n);
        classIntrospectorPerformance.measureClassIntrospector(n);
        classIntrospectorPerformance.measureClassIntrospector(n);
        classIntrospectorPerformance.measureClassIntrospector(n);
        classIntrospectorPerformance.measureClassIntrospector(n);
        classIntrospectorPerformance.measureClassReader();
        classIntrospectorPerformance.measureClassReader();
        classIntrospectorPerformance.measureClassReader();
        classIntrospectorPerformance.measureClassReader();
        classIntrospectorPerformance.measureClassReader();
        classIntrospectorPerformance.measureClassReader();
        classIntrospectorPerformance.measureClassIntrospector(n |= 0x124);
        classIntrospectorPerformance.measureClassIntrospector(n);
        classIntrospectorPerformance.measureClassIntrospector(n);
        classIntrospectorPerformance.measureClassIntrospector(n);
        classIntrospectorPerformance.measureClassIntrospector(n);
        classIntrospectorPerformance.measureClassIntrospector(n);
        n = 73;
        classIntrospectorPerformance.measureClassIntrospector(n);
        classIntrospectorPerformance.measureClassIntrospector(n);
        classIntrospectorPerformance.measureClassIntrospector(n);
        classIntrospectorPerformance.measureClassIntrospector(n);
        classIntrospectorPerformance.measureClassIntrospector(n);
        classIntrospectorPerformance.measureClassIntrospector(n);
    }
}

