/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config;

import com.couchbase.client.core.config.BucketCapabilities;
import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.config.BucketNodeLocator;
import com.couchbase.client.core.config.DefaultNodeInfo;
import com.couchbase.client.core.config.NodeInfo;
import com.couchbase.client.core.config.PortInfo;
import com.couchbase.client.core.service.ServiceType;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AbstractBucketConfig
implements BucketConfig {
    private final String name;
    private String username;
    private String password;
    private final BucketNodeLocator locator;
    private final String uri;
    private final String streamingUri;
    private final List<NodeInfo> nodeInfo;
    private final int enabledServices;
    private final List<BucketCapabilities> bucketCapabilities;

    protected AbstractBucketConfig(String name, BucketNodeLocator locator, String uri, String streamingUri, List<NodeInfo> nodeInfos, List<PortInfo> portInfos, List<BucketCapabilities> bucketCapabilities) {
        this.name = name;
        this.locator = locator;
        this.uri = uri;
        this.streamingUri = streamingUri;
        this.bucketCapabilities = bucketCapabilities;
        this.nodeInfo = portInfos == null ? nodeInfos : this.nodeInfoFromExtended(portInfos, nodeInfos);
        int es = 0;
        for (NodeInfo info : this.nodeInfo) {
            for (ServiceType type : info.services().keySet()) {
                es |= 1 << type.ordinal();
            }
            for (ServiceType type : info.sslServices().keySet()) {
                es |= 1 << type.ordinal();
            }
        }
        this.enabledServices = es;
    }

    private List<NodeInfo> nodeInfoFromExtended(List<PortInfo> nodesExt, List<NodeInfo> nodeInfos) {
        ArrayList<NodeInfo> converted = new ArrayList<NodeInfo>(nodesExt.size());
        for (int i = 0; i < nodesExt.size(); ++i) {
            InetAddress hostname = nodesExt.get(i).hostname();
            if (hostname == null) {
                hostname = nodeInfos.get(i).hostname();
            }
            Map<ServiceType, Integer> ports = nodesExt.get(i).ports();
            Map<ServiceType, Integer> sslPorts = nodesExt.get(i).sslPorts();
            if (!this.bucketCapabilities.contains((Object)BucketCapabilities.COUCHAPI)) {
                ports.remove((Object)ServiceType.VIEW);
                sslPorts.remove((Object)ServiceType.VIEW);
            }
            converted.add(new DefaultNodeInfo(hostname, ports, sslPorts));
        }
        return converted;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public BucketNodeLocator locator() {
        return this.locator;
    }

    @Override
    public String uri() {
        return this.uri;
    }

    @Override
    public String streamingUri() {
        return this.streamingUri;
    }

    @Override
    public List<NodeInfo> nodes() {
        return this.nodeInfo;
    }

    @Override
    public String password() {
        return this.password;
    }

    @Override
    public BucketConfig password(String password) {
        this.password = password;
        return this;
    }

    @Override
    public String username() {
        return this.username;
    }

    @Override
    public BucketConfig username(String username) {
        this.username = username;
        return this;
    }

    @Override
    public boolean serviceEnabled(ServiceType type) {
        return (this.enabledServices & 1 << type.ordinal()) != 0;
    }
}

