/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.backup;

import java.io.File;
import java.io.IOException;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.plugins.segment.file.FileStore;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.EmptyHook;
import org.apache.jackrabbit.oak.spi.state.ApplyDiff;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStoreRestore {
    private static final Logger log = LoggerFactory.getLogger(FileStoreRestore.class);
    static int MAX_FILE_SIZE = 256;
    private static final String JOURNAL_FILE_NAME = "journal.log";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void restore(File source, NodeStore store) throws IOException, CommitFailedException {
        if (!FileStoreRestore.validFileStore(source)) {
            throw new IOException("Folder " + source + " is not a valid FileStore directory");
        }
        FileStore restore = new FileStore(source, MAX_FILE_SIZE, false);
        try {
            SegmentNodeState state = restore.getHead();
            FileStoreRestore.restore(state.getChildNode("root"), store);
        }
        finally {
            restore.close();
        }
    }

    public static void restore(NodeState source, NodeStore store) throws CommitFailedException {
        long s = System.currentTimeMillis();
        NodeState after = store.getRoot();
        NodeBuilder builder = after.builder();
        source.compareAgainstBaseState(after, new ApplyDiff(builder));
        store.merge(builder, EmptyHook.INSTANCE, CommitInfo.EMPTY);
        log.debug("Restore finished in {} ms.", (Object)(System.currentTimeMillis() - s));
    }

    private static boolean validFileStore(File source) {
        if (source == null || !source.isDirectory()) {
            return false;
        }
        for (String f : source.list()) {
            if (!JOURNAL_FILE_NAME.equals(f)) continue;
            return true;
        }
        return false;
    }
}

